/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractRegionScanForActiveDataUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public abstract class AbstractRegionScanDataSourceOperator
extends AbstractSourceOperator
implements DataSourceOperator {
    protected boolean finished = false;
    protected boolean outputCount;
    protected long count = 0L;
    protected AbstractRegionScanForActiveDataUtil regionScanUtil;
    protected TsBlockBuilder resultTsBlockBuilder;

    protected abstract boolean getNextTsFileHandle() throws IOException, IllegalPathException;

    protected abstract boolean isAllDataChecked();

    protected abstract void updateActiveData();

    protected abstract List<TSDataType> getResultDataTypes();

    @Override
    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.regionScanUtil.initQueryDataSource(dataSource);
        this.resultTsBlockBuilder = new TsBlockBuilder(this.getResultDataTypes());
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (this.resultTsBlockBuilder.isEmpty()) {
            return null;
        }
        this.resultTsBlock = this.resultTsBlockBuilder.build();
        this.resultTsBlockBuilder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (!this.resultTsBlockBuilder.isEmpty() || this.retainedTsBlock != null) {
            return true;
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            while (!this.regionScanUtil.isCurrentTsFileFinished() || this.getNextTsFileHandle()) {
                if (!(this.regionScanUtil.filterChunkMetaData() && !this.regionScanUtil.isCurrentTsFileFinished() || this.regionScanUtil.filterChunkData() && !this.regionScanUtil.isCurrentTsFileFinished())) {
                    this.updateActiveData();
                    this.regionScanUtil.finishCurrentFile();
                }
                if (System.nanoTime() - start < maxRuntime && !this.resultTsBlockBuilder.isFull()) continue;
            }
            this.finished = this.resultTsBlockBuilder.isEmpty() && (!this.regionScanUtil.hasMoreData() && this.regionScanUtil.isCurrentTsFileFinished() || this.isAllDataChecked());
            boolean hasCachedCountValue = this.buildCountResultIfNeed();
            return !this.finished || hasCachedCountValue;
        }
        catch (IOException e) {
            throw new IOException("Error occurs when scanning active time series.", e);
        }
    }

    private boolean buildCountResultIfNeed() {
        if (!this.outputCount || !this.finished || this.count == -1L) {
            return false;
        }
        this.resultTsBlockBuilder.getTimeColumnBuilder().writeLong(-1L);
        this.resultTsBlockBuilder.getValueColumnBuilders()[0].writeLong(this.count);
        this.resultTsBlockBuilder.declarePosition();
        this.count = -1L;
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.calculateMaxPeekMemoryWithCounter() - this.calculateMaxReturnSize();
    }

    public long ramBytesUsed() {
        return (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes()) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.regionScanUtil);
    }
}

