/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.memory;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileAbstractMemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileDataCacheMemoryBlock
extends LoadTsFileAbstractMemoryBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileDataCacheMemoryBlock.class);
    private static final long MINIMUM_MEMORY_SIZE_IN_BYTES = 0x100000L;
    private final AtomicLong limitedMemorySizeInBytes;
    private final AtomicLong memoryUsageInBytes;
    private final AtomicInteger referenceCount;

    LoadTsFileDataCacheMemoryBlock(long initialLimitedMemorySizeInBytes) {
        if (initialLimitedMemorySizeInBytes < 0x100000L) {
            throw new LoadRuntimeOutOfMemoryException(String.format("The initial limited memory size %d is less than the minimum memory size %d", initialLimitedMemorySizeInBytes, 0x100000L));
        }
        this.limitedMemorySizeInBytes = new AtomicLong(initialLimitedMemorySizeInBytes);
        this.memoryUsageInBytes = new AtomicLong(0L);
        this.referenceCount = new AtomicInteger(0);
    }

    @Override
    public boolean hasEnoughMemory(long memoryTobeAddedInBytes) {
        return this.memoryUsageInBytes.get() + memoryTobeAddedInBytes <= this.limitedMemorySizeInBytes.get();
    }

    @Override
    public synchronized void addMemoryUsage(long memoryInBytes) {
        if (this.memoryUsageInBytes.addAndGet(memoryInBytes) > this.limitedMemorySizeInBytes.get()) {
            LOGGER.warn("{} has exceed total memory size", (Object)this);
        }
    }

    @Override
    public synchronized void reduceMemoryUsage(long memoryInBytes) {
        if (this.memoryUsageInBytes.addAndGet(-memoryInBytes) < 0L) {
            LOGGER.warn("{} has reduce memory usage to negative", (Object)this);
        }
    }

    @Override
    protected void releaseAllMemory() {
        if (this.memoryUsageInBytes.get() != 0L) {
            LOGGER.warn("Try to release memory from a memory block {} which has not released all memory", (Object)this);
        }
        MEMORY_MANAGER.releaseToQuery(this.limitedMemorySizeInBytes.get());
    }

    public boolean doShrink(long shrinkMemoryInBytes) {
        if (shrinkMemoryInBytes < 0L) {
            LOGGER.warn("Try to shrink a negative memory size {} from memory block {}", (Object)shrinkMemoryInBytes, (Object)this);
            return false;
        }
        if (shrinkMemoryInBytes == 0L) {
            return true;
        }
        if (this.limitedMemorySizeInBytes.get() - shrinkMemoryInBytes <= 0x100000L) {
            return false;
        }
        MEMORY_MANAGER.releaseToQuery(shrinkMemoryInBytes);
        this.limitedMemorySizeInBytes.addAndGet(-shrinkMemoryInBytes);
        return true;
    }

    void updateReferenceCount(int delta) {
        this.referenceCount.addAndGet(delta);
    }

    int getReferenceCount() {
        return this.referenceCount.get();
    }

    long getMemoryUsageInBytes() {
        return this.memoryUsageInBytes.get();
    }

    long getLimitedMemorySizeInBytes() {
        return this.limitedMemorySizeInBytes.get();
    }

    public String toString() {
        return "LoadTsFileDataCacheMemoryBlock{limitedMemorySizeInBytes=" + this.limitedMemorySizeInBytes.get() + ", memoryUsageInBytes=" + this.memoryUsageInBytes.get() + '}';
    }
}

