/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.sync;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.exception.UncheckedStartupException;
import org.apache.iotdb.confignode.client.sync.CnToDnSyncRequestType;
import org.apache.iotdb.mpp.rpc.thrift.TCleanDataNodeCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeResp;
import org.apache.iotdb.mpp.rpc.thrift.TResetPeerListReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.util.function.CheckedBiFunction;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataNodeClientPool.class);
    private static final int DEFAULT_RETRY_NUM = 6;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    protected ImmutableMap<CnToDnSyncRequestType, CheckedBiFunction<Object, SyncDataNodeInternalServiceClient, Object, Exception>> actionMap;

    private SyncDataNodeClientPool() {
        this.buildActionMap();
        this.checkActionMapCompleteness();
    }

    private void buildActionMap() {
        ImmutableMap.Builder actionMapBuilder = ImmutableMap.builder();
        actionMapBuilder.put((Object)CnToDnSyncRequestType.INVALIDATE_PARTITION_CACHE, (req, client) -> client.invalidatePartitionCache((TInvalidateCacheReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.INVALIDATE_SCHEMA_CACHE, (req, client) -> client.invalidateSchemaCache((TInvalidateCacheReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.CREATE_SCHEMA_REGION, (req, client) -> client.createSchemaRegion((TCreateSchemaRegionReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.CREATE_DATA_REGION, (req, client) -> client.createDataRegion((TCreateDataRegionReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.DELETE_REGION, (req, client) -> client.deleteRegion((TConsensusGroupId)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.INVALIDATE_PERMISSION_CACHE, (req, client) -> client.invalidatePermissionCache((TInvalidatePermissionCacheReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.CLEAN_DATA_NODE_CACHE, (req, client) -> client.cleanDataNodeCache((TCleanDataNodeCacheReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.STOP_AND_CLEAR_DATA_NODE, (req, client) -> client.stopAndClearDataNode());
        actionMapBuilder.put((Object)CnToDnSyncRequestType.SET_SYSTEM_STATUS, (req, client) -> client.setSystemStatus((String)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.KILL_QUERY_INSTANCE, (req, client) -> client.killQueryInstance((String)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.UPDATE_TEMPLATE, (req, client) -> client.updateTemplate((TUpdateTemplateReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.CREATE_NEW_REGION_PEER, (req, client) -> client.createNewRegionPeer((TCreatePeerReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.ADD_REGION_PEER, (req, client) -> client.addRegionPeer((TMaintainPeerReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.REMOVE_REGION_PEER, (req, client) -> client.removeRegionPeer((TMaintainPeerReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.DELETE_OLD_REGION_PEER, (req, client) -> client.deleteOldRegionPeer((TMaintainPeerReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.RESET_PEER_LIST, (req, client) -> client.resetPeerList((TResetPeerListReq)req));
        actionMapBuilder.put((Object)CnToDnSyncRequestType.SHOW_CONFIGURATION, (req, client) -> client.showConfiguration());
        this.actionMap = actionMapBuilder.build();
    }

    private void checkActionMapCompleteness() {
        List lackList = Arrays.stream(CnToDnSyncRequestType.values()).filter(type -> !this.actionMap.containsKey((Object)type)).collect(Collectors.toList());
        if (!lackList.isEmpty()) {
            throw new UncheckedStartupException(String.format("These request types should be added to actionMap: %s", lackList));
        }
    }

    public Object sendSyncRequestToDataNodeWithRetry(TEndPoint endPoint, Object req, CnToDnSyncRequestType requestType) {
        Object lastException = new TException();
        int retry = 0;
        while (retry < 6) {
            Object object;
            block10: {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
                try {
                    object = this.executeSyncRequest(requestType, client, req);
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        lastException = e;
                        if (retry != 5) {
                            LOGGER.warn("{} failed on DataNode {}, retrying {}...", new Object[]{requestType, endPoint, retry + 1});
                            this.doRetryWait(retry);
                        }
                        ++retry;
                    }
                }
                client.close();
            }
            return object;
        }
        LOGGER.error("{} failed on DataNode {}", new Object[]{requestType, endPoint, lastException});
        return new TSStatus(TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode()).setMessage("All retry failed due to: " + ((Throwable)lastException).getMessage());
    }

    public Object sendSyncRequestToDataNodeWithGivenRetry(TEndPoint endPoint, Object req, CnToDnSyncRequestType requestType, int retryNum) {
        Object lastException = new TException();
        int retry = 0;
        while (retry < retryNum) {
            Object object;
            block10: {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
                try {
                    object = this.executeSyncRequest(requestType, client, req);
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        lastException = e;
                        if (retry != retryNum - 1) {
                            LOGGER.warn("{} failed on DataNode {}, retrying {}...", new Object[]{requestType, endPoint, retry + 1});
                            this.doRetryWait(retry);
                        }
                        ++retry;
                    }
                }
                client.close();
            }
            return object;
        }
        LOGGER.error("{} failed on DataNode {}", new Object[]{requestType, endPoint, lastException});
        return new TSStatus(TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode()).setMessage("All retry failed due to: " + ((Throwable)lastException).getMessage());
    }

    private Object executeSyncRequest(CnToDnSyncRequestType requestType, SyncDataNodeInternalServiceClient client, Object req) throws Exception {
        return Objects.requireNonNull((CheckedBiFunction)this.actionMap.get((Object)requestType)).apply(req, (Object)client);
    }

    private void doRetryWait(int retryNum) {
        try {
            if (retryNum < 3) {
                TimeUnit.MILLISECONDS.sleep(800L);
            } else if (retryNum < 5) {
                TimeUnit.MILLISECONDS.sleep(100L * (long)Math.pow(2.0, retryNum));
            } else {
                TimeUnit.MILLISECONDS.sleep(3200L);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Retry wait failed.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public TRegionLeaderChangeResp changeRegionLeader(TConsensusGroupId regionId, TEndPoint dataNode, TDataNodeLocation newLeaderNode) {
        TSStatus status;
        block10: {
            TRegionLeaderChangeResp tRegionLeaderChangeResp;
            block9: {
                LOGGER.info("Send RPC to data node: {} for changing regions leader on it", (Object)dataNode);
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)dataNode);
                try {
                    TRegionLeaderChangeReq req = new TRegionLeaderChangeReq(regionId, newLeaderNode);
                    tRegionLeaderChangeResp = client.changeRegionLeader(req);
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ClientManagerException e) {
                        LOGGER.error("Can't connect to Data node: {}", (Object)dataNode, (Object)e);
                        status = new TSStatus(TSStatusCode.CAN_NOT_CONNECT_DATANODE.getStatusCode());
                        status.setMessage(e.getMessage());
                        break block10;
                    }
                    catch (TException e) {
                        LOGGER.error("Change regions leader error on Date node: {}", (Object)dataNode, (Object)e);
                        status = new TSStatus(TSStatusCode.REGION_LEADER_CHANGE_ERROR.getStatusCode());
                        status.setMessage(e.getMessage());
                    }
                }
                client.close();
            }
            return tRegionLeaderChangeResp;
        }
        return new TRegionLeaderChangeResp(status, -1L);
    }

    public static SyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final SyncDataNodeClientPool INSTANCE = new SyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

