/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.AbstractStatistics;
import org.apache.iotdb.confignode.manager.load.cache.IFailureDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.FixedDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.PhiAccrualDetector;

public abstract class AbstractLoadCache {
    private static final int MAXIMUM_WINDOW_SIZE = 100;
    protected final List<AbstractHeartbeatSample> slidingWindow;
    protected final AtomicReference<AbstractStatistics> currentStatistics = new AtomicReference();
    protected final IFailureDetector failureDetector;
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();

    protected AbstractLoadCache() {
        this.slidingWindow = Collections.synchronizedList(new LinkedList());
        switch (CONF.getFailureDetector()) {
            case "phi_accrual": {
                this.failureDetector = new PhiAccrualDetector(CONF.getFailureDetectorPhiThreshold(), CONF.getFailureDetectorPhiAcceptablePauseInMs() * 1000000L, CONF.getHeartbeatIntervalInMs() * 200000L, 60, new FixedDetector(CONF.getFailureDetectorFixedThresholdInMs() * 1000000L));
                break;
            }
            default: {
                this.failureDetector = new FixedDetector(CONF.getFailureDetectorFixedThresholdInMs() * 1000000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(AbstractHeartbeatSample newHeartbeatSample) {
        List<AbstractHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            if (this.getLastSample() == null || this.getLastSample().getSampleLogicalTimestamp() <= newHeartbeatSample.getSampleLogicalTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.remove(0);
            }
        }
    }

    public AbstractHeartbeatSample getLastSample() {
        return this.slidingWindow.isEmpty() ? null : this.slidingWindow.get(this.slidingWindow.size() - 1);
    }

    public abstract void updateCurrentStatistics(boolean var1);

    public AbstractStatistics getCurrentStatistics() {
        return this.currentStatistics.get();
    }
}

