/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class GKArray {
    private final double rankAccuracy;
    private ArrayList<Tuple> entries;
    private final double[] incoming;
    private int incomingIndex;
    private long compressedCount;
    private double minValue;

    public GKArray(double rankAccuracy) {
        this.rankAccuracy = rankAccuracy;
        this.entries = new ArrayList();
        this.incoming = new double[(int)(1.0 / rankAccuracy) + 1];
        this.incomingIndex = 0;
        this.minValue = Double.MAX_VALUE;
        this.compressedCount = 0L;
    }

    public void insert(double value) {
        if (Double.isFinite(value)) {
            this.incoming[this.incomingIndex++] = value;
            if (this.incomingIndex == this.incoming.length) {
                this.compress();
            }
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty() && this.incomingIndex == 0;
    }

    public double query(double phi) {
        int i;
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        this.compressIfNecessary();
        long rank = (long)(phi * (double)(this.compressedCount - 1L)) + 1L;
        long spread = (long)(this.rankAccuracy * (double)(this.compressedCount - 1L));
        long gSum = 0L;
        for (i = 0; i < this.entries.size() && (gSum += this.entries.get(i).g) + this.entries.get(i).delta <= rank + spread; ++i) {
        }
        if (i == 0) {
            return this.minValue;
        }
        return this.entries.get(i - 1).v;
    }

    private void compressIfNecessary() {
        if (this.incomingIndex > 0) {
            this.compress();
        }
    }

    private void compress() {
        this.compress(new ArrayList<Tuple>());
    }

    private void compress(List<Tuple> additionalEntries) {
        for (int i = 0; i < this.incomingIndex; ++i) {
            additionalEntries.add(new Tuple(this.incoming[i], 1L, 0L));
        }
        additionalEntries.sort(Comparator.comparingDouble(e -> ((Tuple)e).v));
        this.compressedCount += (long)this.incomingIndex;
        if (!additionalEntries.isEmpty()) {
            this.minValue = Math.min(this.minValue, additionalEntries.get(0).v);
        }
        long removalThreshold = 2L * (long)(this.rankAccuracy * (double)(this.compressedCount - 1L));
        ArrayList<Tuple> mergedEntries = new ArrayList<Tuple>(this.entries.size() + additionalEntries.size() / 3);
        int i = 0;
        int j = 0;
        while (i < additionalEntries.size() || j < this.entries.size()) {
            if (j == this.entries.size()) {
                if (i + 1 < additionalEntries.size() && additionalEntries.get(i).g + additionalEntries.get(i + 1).g + additionalEntries.get(i + 1).delta <= removalThreshold) {
                    additionalEntries.get(i + 1).g += additionalEntries.get(i).g;
                } else {
                    mergedEntries.add(additionalEntries.get(i));
                }
                ++i;
                continue;
            }
            if (additionalEntries.get(i).v < this.entries.get(j).v) {
                if (additionalEntries.get(i).g + this.entries.get(j).g + this.entries.get(j).delta <= removalThreshold) {
                    this.entries.get(j).g += additionalEntries.get(i).g;
                } else {
                    additionalEntries.get(i).delta = this.entries.get(j).g + this.entries.get(j).delta - additionalEntries.get(i).g;
                    mergedEntries.add(additionalEntries.get(i));
                }
                ++i;
                continue;
            }
            if (j + 1 < this.entries.size() && this.entries.get(j).g + this.entries.get(j + 1).g + this.entries.get(j + 1).delta <= removalThreshold) {
                this.entries.get(j + 1).g += this.entries.get(j).g;
            } else {
                mergedEntries.add(this.entries.get(j));
            }
            ++j;
        }
        this.entries = mergedEntries;
        this.incomingIndex = 0;
    }

    static class Tuple
    implements Serializable {
        private final double v;
        private long g;
        private long delta;

        private Tuple(double v, long g2, long delta) {
            this.v = v;
            this.g = g2;
            this.delta = delta;
        }
    }
}

