/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLeaderBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLeaderBalancer.class);
    public static final String GREEDY_POLICY = "GREEDY";
    public static final String CFD_POLICY = "CFD";
    protected final Set<TConsensusGroupId> regionGroupIntersection = new TreeSet<TConsensusGroupId>();
    protected final Map<String, List<TConsensusGroupId>> databaseRegionGroupMap = new TreeMap<String, List<TConsensusGroupId>>();
    protected final Map<TConsensusGroupId, Set<Integer>> regionLocationMap = new TreeMap<TConsensusGroupId, Set<Integer>>();
    protected final Map<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
    protected final Map<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
    protected final Map<TConsensusGroupId, Map<Integer, RegionStatistics>> regionStatisticsMap = new TreeMap<TConsensusGroupId, Map<Integer, RegionStatistics>>();

    protected AbstractLeaderBalancer() {
    }

    protected void initialize(Map<String, List<TConsensusGroupId>> databaseRegionGroupMap, Map<TConsensusGroupId, Set<Integer>> regionLocationMap, Map<TConsensusGroupId, Integer> regionLeaderMap, Map<Integer, NodeStatistics> dataNodeStatisticsMap, Map<TConsensusGroupId, Map<Integer, RegionStatistics>> regionStatisticsMap) {
        this.databaseRegionGroupMap.putAll(databaseRegionGroupMap);
        this.regionLocationMap.putAll(regionLocationMap);
        this.regionLeaderMap.putAll(regionLeaderMap);
        this.dataNodeStatisticsMap.putAll(dataNodeStatisticsMap);
        this.regionStatisticsMap.putAll(regionStatisticsMap);
        Set regionGroupUnionSet = databaseRegionGroupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        this.regionGroupIntersection.addAll(regionGroupUnionSet);
        this.regionGroupIntersection.retainAll(regionLocationMap.keySet());
        this.regionGroupIntersection.retainAll(regionLeaderMap.keySet());
        this.regionGroupIntersection.retainAll(regionStatisticsMap.keySet());
        regionGroupUnionSet.addAll(regionLocationMap.keySet());
        regionGroupUnionSet.addAll(regionLeaderMap.keySet());
        regionGroupUnionSet.addAll(regionStatisticsMap.keySet());
        Set<TConsensusGroupId> differenceSet = regionGroupUnionSet.stream().filter(e -> !this.regionGroupIntersection.contains(e)).collect(Collectors.toSet());
        if (!differenceSet.isEmpty()) {
            LOGGER.warn("[LeaderBalancer] The following RegionGroups' leader cannot be selected because their corresponding caches are incomplete: {}", differenceSet);
            Set databaseRegionGroupUnionSet = databaseRegionGroupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            differenceSet.forEach(regionId -> {
                if (!databaseRegionGroupUnionSet.contains(regionId)) {
                    LOGGER.warn("[LeaderBalancer] Region: {} not in databaseRegionGroupMap", regionId);
                }
                if (!regionLocationMap.containsKey(regionId)) {
                    LOGGER.warn("[LeaderBalancer] Region: {} not in regionLocationMap", regionId);
                }
                if (!regionLeaderMap.containsKey(regionId)) {
                    LOGGER.warn("[LeaderBalancer] Region: {} not in regionLeaderMap", regionId);
                }
                if (!regionStatisticsMap.containsKey(regionId)) {
                    LOGGER.warn("[LeaderBalancer] Region: {} not in regionStatisticsMap", regionId);
                }
            });
        }
    }

    protected boolean isDataNodeAvailable(int dataNodeId) {
        return this.dataNodeStatisticsMap.containsKey(dataNodeId) && NodeStatus.Running.equals((Object)this.dataNodeStatisticsMap.get(dataNodeId).getStatus());
    }

    protected boolean isRegionAvailable(TConsensusGroupId regionGroupId, int dataNodeId) {
        return this.regionStatisticsMap.containsKey(regionGroupId) && this.regionStatisticsMap.get(regionGroupId).containsKey(dataNodeId) && RegionStatus.Running.equals((Object)this.regionStatisticsMap.get(regionGroupId).get(dataNodeId).getRegionStatus());
    }

    protected void clear() {
        this.regionGroupIntersection.clear();
        this.databaseRegionGroupMap.clear();
        this.regionLocationMap.clear();
        this.regionLeaderMap.clear();
        this.dataNodeStatisticsMap.clear();
        this.regionStatisticsMap.clear();
    }

    public abstract Map<TConsensusGroupId, Integer> generateOptimalLeaderDistribution(Map<String, List<TConsensusGroupId>> var1, Map<TConsensusGroupId, Set<Integer>> var2, Map<TConsensusGroupId, Integer> var3, Map<Integer, NodeStatistics> var4, Map<TConsensusGroupId, Map<Integer, RegionStatistics>> var5);
}

