/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;

public enum WALFileVersion {
    V1("WAL"),
    V2("V2-WAL");

    private final String versionString;
    private byte[] versionBytes;

    public String getVersionString() {
        return this.versionString;
    }

    public byte[] getVersionBytes() {
        return this.versionBytes;
    }

    private WALFileVersion(String versionString) {
        this.versionString = versionString;
        if (versionString != null) {
            this.versionBytes = versionString.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static WALFileVersion getVersion(File file) throws IOException {
        try (FileChannel channel = FileChannel.open(file.toPath(), new OpenOption[0]);){
            WALFileVersion wALFileVersion = WALFileVersion.getVersion(channel);
            return wALFileVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WALFileVersion getVersion(FileChannel channel) throws IOException {
        long originalPosition = channel.position();
        try {
            WALFileVersion[] versions;
            for (WALFileVersion version : versions = new WALFileVersion[]{V2}) {
                channel.position(0L);
                if (channel.size() < (long)version.versionBytes.length) continue;
                ByteBuffer buffer = ByteBuffer.allocate(version.versionBytes.length);
                channel.read(buffer);
                buffer.flip();
                String versionString = new String(buffer.array(), StandardCharsets.UTF_8);
                if (!version.versionString.equals(versionString)) continue;
                WALFileVersion wALFileVersion = version;
                return wALFileVersion;
            }
            WALFileVersion wALFileVersion = V1;
            return wALFileVersion;
        }
        finally {
            channel.position(originalPosition);
        }
    }
}

