/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class OpenCloseState {
    private final String name;
    private final Throwable initTrace;
    private final AtomicReference<Throwable> state;

    public OpenCloseState(String name) {
        this.name = name;
        this.initTrace = new Throwable("Initialize " + name);
        this.state = new AtomicReference<Throwable>(this.initTrace);
    }

    public void assertOpen() {
        Throwable t = this.state.get();
        if (!(t instanceof OpenTrace)) {
            String s = this.name + " is expected to be opened but it is " + this.toString(t);
            throw new IllegalStateException(s, t);
        }
    }

    public boolean isUnopened() {
        return this.state.get() == this.initTrace;
    }

    public boolean isOpened() {
        return this.state.get() instanceof OpenTrace;
    }

    public boolean isClosed() {
        return this.state.get() instanceof CloseTrace;
    }

    public Throwable getThrowable() {
        return this.state.get();
    }

    public void open() throws IOException {
        OpenTrace openTrace = new OpenTrace("Open " + this.name);
        Throwable t = this.state.updateAndGet(previous -> previous == this.initTrace ? openTrace : previous);
        if (t != openTrace) {
            throw new IOException("Failed to open " + this.name + " since it is " + this.toString(t));
        }
    }

    private boolean readyToClose(Throwable t) {
        return t == this.initTrace || t instanceof OpenTrace;
    }

    public boolean close() throws IOException {
        Throwable previous = this.state.getAndUpdate(prev -> this.readyToClose((Throwable)prev) ? new CloseTrace("Close " + this.name) : prev);
        if (this.readyToClose(previous)) {
            return true;
        }
        if (previous instanceof CloseTrace) {
            return false;
        }
        throw new IOException("Failed to close " + this.name + " since it is " + this.toString(previous));
    }

    public String toString() {
        return this.toString(this.state.get());
    }

    private String toString(Throwable t) {
        return t == this.initTrace ? "UNOPENED" : (t instanceof OpenTrace ? "OPENED" : (t instanceof CloseTrace ? "CLOSED" : t.toString()));
    }

    private static class OpenTrace
    extends Throwable {
        OpenTrace(String message) {
            super(message);
        }
    }

    private static class CloseTrace
    extends Throwable {
        CloseTrace(String message) {
            super(message);
        }
    }
}

