/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.receiver;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeConfigNodeReceiverMetrics
implements IMetricSet {
    private static final PipeConfigNodeReceiverMetrics INSTANCE = new PipeConfigNodeReceiverMetrics();
    private Timer handshakeConfigNodeV1Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer handshakeConfigNodeV2Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferConfigPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferConfigSnapshotPieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferConfigSnapshotSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String RECEIVER = "pipeConfigNodeReceiver";

    private PipeConfigNodeReceiverMetrics() {
    }

    public void recordHandshakeConfigNodeV1Timer(long costTimeInNanos) {
        this.handshakeConfigNodeV1Timer.updateNanos(costTimeInNanos);
    }

    public void recordHandshakeConfigNodeV2Timer(long costTimeInNanos) {
        this.handshakeConfigNodeV2Timer.updateNanos(costTimeInNanos);
    }

    public void recordTransferConfigPlanTimer(long costTimeInNanos) {
        this.transferConfigPlanTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferConfigSnapshotPieceTimer(long costTimeInNanos) {
        this.transferConfigSnapshotPieceTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferConfigSnapshotSealTimer(long costTimeInNanos) {
        this.transferConfigSnapshotSealTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindToTimer(metricService);
    }

    private void bindToTimer(AbstractMetricService metricService) {
        this.handshakeConfigNodeV1Timer = metricService.getOrCreateTimer(Metric.PIPE_CONFIGNODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeConfigNodeV1"});
        this.handshakeConfigNodeV2Timer = metricService.getOrCreateTimer(Metric.PIPE_CONFIGNODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeConfigNodeV2"});
        this.transferConfigPlanTimer = metricService.getOrCreateTimer(Metric.PIPE_CONFIGNODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigPlan"});
        this.transferConfigSnapshotPieceTimer = metricService.getOrCreateTimer(Metric.PIPE_CONFIGNODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigSnapshotPiece"});
        this.transferConfigSnapshotSealTimer = metricService.getOrCreateTimer(Metric.PIPE_CONFIGNODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigSnapshotSeal"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbind(metricService);
    }

    private void unbind(AbstractMetricService metricService) {
        this.handshakeConfigNodeV1Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.handshakeConfigNodeV2Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferConfigPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferConfigSnapshotPieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferConfigSnapshotSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.PIPE_CONFIGNODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeConfigNodeV1"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_CONFIGNODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeConfigNodeV2"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_CONFIGNODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigPlan"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_CONFIGNODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigSnapshotPiece"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_CONFIGNODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigSnapshotSeal"});
    }

    public static PipeConfigNodeReceiverMetrics getInstance() {
        return INSTANCE;
    }
}

