/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.tsfile.read.reader.chunk.TableChunkReader;

public class DiskAlignedChunkLoader
implements IChunkLoader {
    private final QueryContext context;
    private final TsFileResource resource;
    private final boolean ignoreAllNullRows;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskAlignedChunkLoader(QueryContext context, TsFileResource resource, boolean ignoreAllNullRows) {
        this.context = context;
        this.resource = resource;
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            AbstractAlignedChunkMetadata alignedChunkMetadata = (AbstractAlignedChunkMetadata)chunkMetaData;
            ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
            Chunk timeChunk = ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), timeChunkMetadata.getOffsetOfChunkHeader(), this.resource.isClosed()), timeChunkMetadata.getDeleteIntervalList(), timeChunkMetadata.getStatistics(), this.context);
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                valueChunkList.add(valueChunkMetadata == null ? null : ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), valueChunkMetadata.getOffsetOfChunkHeader(), this.resource.isClosed()), valueChunkMetadata.getDeleteIntervalList(), valueChunkMetadata.getStatistics(), this.context));
            }
            long t2 = System.nanoTime();
            AlignedChunkReader chunkReader = this.ignoreAllNullRows ? new AlignedChunkReader(timeChunk, valueChunkList, globalTimeFilter) : new TableChunkReader(timeChunk, valueChunkList, globalTimeFilter);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_aligned_disk", System.nanoTime() - t2);
            AlignedChunkReader alignedChunkReader = chunkReader;
            return alignedChunkReader;
        }
        finally {
            long time = System.nanoTime() - t1;
            this.context.getQueryStatistics().getConstructAlignedChunkReadersDiskCount().getAndAdd(1L);
            this.context.getQueryStatistics().getConstructAlignedChunkReadersDiskTime().getAndAdd(time);
        }
    }

    public TsFileID getTsFileID() {
        return this.resource.getTsFileID();
    }
}

