/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.james.util.UnitParser;

public class SizeFormat {
    public static String format(long bytesCount) {
        Preconditions.checkArgument(bytesCount >= 0L, "Formatting of a negative size is forbidden");
        return Unit.locateUnit(bytesCount).format(bytesCount);
    }

    public static long parseAsByteCount(String bytesWithUnit) {
        UnitParser.ParsingResult parsingResult = UnitParser.parse(bytesWithUnit);
        Unit unit = parsingResult.getUnit().map(rawValue -> Unit.of(rawValue).orElseThrow(() -> new IllegalArgumentException("Unknown unit " + rawValue))).orElse(Unit.Byte);
        return unit.toByteCount(parsingResult.getNumber());
    }

    public static enum Unit {
        TiB(FileUtils.ONE_TB_BI, "TiB"),
        GiB(FileUtils.ONE_GB_BI, "GiB"),
        MiB(FileUtils.ONE_MB_BI, "MiB"),
        KiB(FileUtils.ONE_KB_BI, "KiB"),
        Byte(BigInteger.valueOf(1L), "bytes");

        private static final int SCALE = 2;
        private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS;
        private static final DecimalFormat DECIMAL_FORMAT;
        private final BigInteger bytesCount;
        private final String notation;

        static Unit locateUnit(long bytesCount) {
            if (bytesCount / 0x10000000000L > 0L) {
                return TiB;
            }
            if (bytesCount / 0x40000000L > 0L) {
                return GiB;
            }
            if (bytesCount / 0x100000L > 0L) {
                return MiB;
            }
            if (bytesCount / 1024L > 0L) {
                return KiB;
            }
            return Byte;
        }

        public static Optional<Unit> of(String rawValue) {
            return Arrays.stream(Unit.values()).filter(unit -> unit.notation.equals(rawValue)).findAny();
        }

        private Unit(BigInteger bytesCount, String notation) {
            this.bytesCount = bytesCount;
            this.notation = notation;
        }

        public long toByteCount(long value) {
            return this.bytesCount.multiply(BigInteger.valueOf(value)).longValueExact();
        }

        public String format(long size) {
            return this.format(new BigDecimal(size));
        }

        public String format(BigDecimal sizeAsDecimal) {
            return this.asString(this.scaleToUnit(sizeAsDecimal)) + " " + this.notation;
        }

        public BigDecimal scaleToUnit(BigDecimal sizeAsDecimal) {
            return sizeAsDecimal.divide(new BigDecimal(this.bytesCount), 2, RoundingMode.FLOOR);
        }

        private String asString(BigDecimal bigDecimal) {
            return DECIMAL_FORMAT.format(bigDecimal.doubleValue());
        }

        static {
            DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
            DECIMAL_FORMAT = new DecimalFormat("0.##", DECIMAL_FORMAT_SYMBOLS);
        }
    }
}

