/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.Version;
import reactor.netty.http.server.HttpServerRequest;

public class VersionParser {
    private static final String JMAP_VERSION_HEADER = "jmapVersion";
    private final Map<String, Version> supportedVersions;
    private final JMAPConfiguration jmapConfiguration;

    @Inject
    public VersionParser(Set<Version> supportedVersions, JMAPConfiguration jmapConfiguration) {
        this.jmapConfiguration = jmapConfiguration;
        Preconditions.checkArgument((boolean)supportedVersions.contains(jmapConfiguration.getDefaultVersion()), (String)"%s is not a supported JMAP version", (Object)jmapConfiguration);
        this.supportedVersions = (Map)supportedVersions.stream().collect(ImmutableMap.toImmutableMap(version -> version.asString().toLowerCase(Locale.US), Function.identity()));
    }

    public Set<Version> getSupportedVersions() {
        return ImmutableSet.copyOf(this.supportedVersions.values());
    }

    @VisibleForTesting
    Version parse(String version) {
        Preconditions.checkNotNull((Object)version);
        return Optional.ofNullable(this.supportedVersions.get(version.toLowerCase(Locale.US))).orElseThrow(() -> new IllegalArgumentException(version + " is not a supported version"));
    }

    Version parseRequestVersionHeader(HttpServerRequest request) {
        return this.acceptParameters(request).filter(nameValuePair -> nameValuePair.getName().equals(JMAP_VERSION_HEADER)).map(NameValuePair::getValue).map(this::parse).findFirst().orElse(this.jmapConfiguration.getDefaultVersion());
    }

    private Stream<NameValuePair> acceptParameters(HttpServerRequest request) {
        return this.extractValueParameters(request.requestHeaders().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    private Stream<NameValuePair> extractValueParameters(String value) {
        return Optional.ofNullable(value).map(nonNull -> Arrays.stream(BasicHeaderValueParser.parseParameters((String)value, (HeaderValueParser)BasicHeaderValueParser.INSTANCE))).orElse(Stream.empty());
    }
}

