/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.Collector;
import org.opensearch.client.opensearch.core.search.QueryProfile;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SearchProfile
implements PlainJsonSerializable {
    private final List<Collector> collector;
    private final List<QueryProfile> query;
    private final long rewriteTime;
    public static final JsonpDeserializer<SearchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchProfile::setupSearchProfileDeserializer);

    private SearchProfile(Builder builder) {
        this.collector = ApiTypeHelper.unmodifiableRequired(builder.collector, (Object)this, "collector");
        this.query = ApiTypeHelper.unmodifiableRequired(builder.query, (Object)this, "query");
        this.rewriteTime = ApiTypeHelper.requireNonNull(builder.rewriteTime, this, "rewriteTime");
    }

    public static SearchProfile of(Function<Builder, ObjectBuilder<SearchProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Collector> collector() {
        return this.collector;
    }

    public final List<QueryProfile> query() {
        return this.query;
    }

    public final long rewriteTime() {
        return this.rewriteTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.collector)) {
            generator.writeKey("collector");
            generator.writeStartArray();
            for (Collector collector : this.collector) {
                collector.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.query)) {
            generator.writeKey("query");
            generator.writeStartArray();
            for (QueryProfile queryProfile : this.query) {
                queryProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("rewrite_time");
        generator.write(this.rewriteTime);
    }

    protected static void setupSearchProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collector, JsonpDeserializer.arrayDeserializer(Collector._DESERIALIZER), "collector");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(QueryProfile._DESERIALIZER), "query");
        op.add(Builder::rewriteTime, JsonpDeserializer.longDeserializer(), "rewrite_time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchProfile> {
        private List<Collector> collector;
        private List<QueryProfile> query;
        private Long rewriteTime;

        public final Builder collector(List<Collector> list) {
            this.collector = Builder._listAddAll(this.collector, list);
            return this;
        }

        public final Builder collector(Collector value, Collector ... values) {
            this.collector = Builder._listAdd(this.collector, value, values);
            return this;
        }

        public final Builder collector(Function<Collector.Builder, ObjectBuilder<Collector>> fn) {
            return this.collector(fn.apply(new Collector.Builder()).build(), new Collector[0]);
        }

        public final Builder query(List<QueryProfile> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        public final Builder query(QueryProfile value, QueryProfile ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        public final Builder query(Function<QueryProfile.Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.query(fn.apply(new QueryProfile.Builder()).build(), new QueryProfile[0]);
        }

        public final Builder rewriteTime(long value) {
            this.rewriteTime = value;
            return this;
        }

        @Override
        public SearchProfile build() {
            this._checkSingleUse();
            return new SearchProfile(this);
        }
    }
}

