/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.NullableMessageSequenceNumber;

public class UidMsnConverter {
    private static final int FIRST_MSN = 1;
    private static final long INTEGER_MAX_VALUE = Integer.MAX_VALUE;
    @VisibleForTesting
    final LongArrayList uids = new LongArrayList();
    @VisibleForTesting
    final IntArrayList uidsAsInts = new IntArrayList();
    @VisibleForTesting
    boolean usesInts = true;

    public synchronized void addAll(Collection<MessageUid> addedUids) {
        this.addAllUnSynchronized(addedUids);
    }

    private void addAllUnSynchronized(Collection<MessageUid> addedUids) {
        if (this.usesInts) {
            if (this.uidsAsInts.isEmpty()) {
                this.addAllToEmptyIntStructure(addedUids);
            } else {
                this.addAllToNonEmptyIntStructure(addedUids);
            }
        } else if (this.uids.isEmpty()) {
            this.addAllToEmptyLongStructure(addedUids);
        } else {
            this.addAllToNonEmptyLongStructure(addedUids);
        }
    }

    private void addAllToNonEmptyLongStructure(Collection<MessageUid> addedUids) {
        LongAVLTreeSet tmp = new LongAVLTreeSet((LongCollection)this.uids);
        for (MessageUid uid : addedUids) {
            tmp.add(uid.asLong());
        }
        this.uids.clear();
        this.uids.addAll((LongCollection)tmp);
    }

    private void addAllToEmptyLongStructure(Collection<MessageUid> addedUids) {
        this.uids.ensureCapacity(addedUids.size());
        for (MessageUid uid : addedUids) {
            this.uids.add(uid.asLong());
        }
        this.uids.sort(LongComparators.NATURAL_COMPARATOR);
    }

    private void addAllToNonEmptyIntStructure(Collection<MessageUid> addedUids) {
        IntAVLTreeSet tmp = new IntAVLTreeSet((IntCollection)this.uidsAsInts);
        for (MessageUid uid : addedUids) {
            if (uid.asLong() > Integer.MAX_VALUE) {
                this.switchToLongs();
                this.addAllUnSynchronized(addedUids);
                return;
            }
            tmp.add((int)uid.asLong());
        }
        this.uidsAsInts.clear();
        this.uidsAsInts.addAll((IntCollection)tmp);
    }

    private void addAllToEmptyIntStructure(Collection<MessageUid> addedUids) {
        this.uidsAsInts.ensureCapacity(addedUids.size());
        for (MessageUid uid : addedUids) {
            if (uid.asLong() > Integer.MAX_VALUE) {
                this.uidsAsInts.clear();
                this.switchToLongs();
                this.addAllUnSynchronized(addedUids);
                return;
            }
            this.uidsAsInts.add((int)uid.asLong());
        }
        this.uidsAsInts.sort(IntComparators.NATURAL_COMPARATOR);
    }

    private void switchToLongs() {
        this.usesInts = false;
        this.uids.ensureCapacity(this.uidsAsInts.size());
        for (int i = 0; i < this.uidsAsInts.size(); ++i) {
            this.uids.add((long)this.uidsAsInts.getInt(i));
        }
        this.uidsAsInts.clear();
        this.uidsAsInts.trim();
    }

    public synchronized NullableMessageSequenceNumber getMsn(MessageUid uid) {
        return this.getMsnUnsynchronized(uid);
    }

    private NullableMessageSequenceNumber getMsnUnsynchronized(MessageUid uid) {
        if (this.usesInts) {
            if (uid.asLong() > Integer.MAX_VALUE) {
                return NullableMessageSequenceNumber.noMessage();
            }
            int position = Arrays.binarySearch(this.uidsAsInts.elements(), 0, this.uidsAsInts.size(), (int)uid.asLong());
            if (position < 0) {
                return NullableMessageSequenceNumber.noMessage();
            }
            return NullableMessageSequenceNumber.of(position + 1);
        }
        int position = Arrays.binarySearch(this.uids.elements(), 0, this.uids.size(), uid.asLong());
        if (position < 0) {
            return NullableMessageSequenceNumber.noMessage();
        }
        return NullableMessageSequenceNumber.of(position + 1);
    }

    public synchronized Optional<MessageUid> getUid(int msn) {
        if (this.usesInts) {
            if (msn <= this.uidsAsInts.size() && msn > 0) {
                return Optional.of(MessageUid.of((long)this.uidsAsInts.getInt(msn - 1)));
            }
        } else if (msn <= this.uids.size() && msn > 0) {
            return Optional.of(MessageUid.of((long)this.uids.getLong(msn - 1)));
        }
        return Optional.empty();
    }

    public synchronized Optional<MessageUid> getLastUid() {
        if (this.uidsAsInts.isEmpty() && this.uids.isEmpty()) {
            return Optional.empty();
        }
        return this.getUid(this.getLastMsn());
    }

    public synchronized List<MessageUid> allUids() {
        if (this.usesInts) {
            return (List)this.uidsAsInts.intStream().mapToObj(MessageUid::of).collect(ImmutableList.toImmutableList());
        }
        return (List)this.uids.longStream().mapToObj(MessageUid::of).collect(ImmutableList.toImmutableList());
    }

    public synchronized Optional<MessageUid> getFirstUid() {
        return this.getUid(1);
    }

    public synchronized int getNumMessage() {
        if (this.usesInts) {
            return this.uidsAsInts.size();
        }
        return this.uids.size();
    }

    public synchronized void remove(MessageUid uid) {
        this.removeUnsynchronized(uid);
    }

    private void removeUnsynchronized(MessageUid uid) {
        if (this.usesInts) {
            if (uid.asLong() > Integer.MAX_VALUE) {
                return;
            }
            int index = Arrays.binarySearch(this.uidsAsInts.elements(), 0, this.uidsAsInts.size(), (int)uid.asLong());
            if (index >= 0) {
                this.uidsAsInts.removeInt(index);
            }
        } else {
            int index = Arrays.binarySearch(this.uids.elements(), 0, this.uids.size(), uid.asLong());
            if (index >= 0) {
                this.uids.removeLong(index);
            }
        }
    }

    public synchronized NullableMessageSequenceNumber getAndRemove(MessageUid uid) {
        NullableMessageSequenceNumber result = this.getMsnUnsynchronized(uid);
        this.removeUnsynchronized(uid);
        return result;
    }

    public synchronized boolean isEmpty() {
        return this.uids.isEmpty() && this.uidsAsInts.isEmpty();
    }

    public synchronized void clear() {
        this.uids.clear();
        this.uidsAsInts.clear();
    }

    public synchronized void addUid(MessageUid uid) {
        this.addUidUnSynchronized(uid);
    }

    private void addUidUnSynchronized(MessageUid uid) {
        if (this.usesInts) {
            if (uid.asLong() > Integer.MAX_VALUE) {
                this.switchToLongs();
                this.addUidUnSynchronized(uid);
                return;
            }
            if (this.isLastUid(uid)) {
                this.uidsAsInts.add((int)uid.asLong());
                return;
            }
            if (this.contains(uid)) {
                return;
            }
            this.uidsAsInts.add((int)uid.asLong());
            this.uidsAsInts.sort(IntComparators.NATURAL_COMPARATOR);
        } else {
            if (this.isLastUid(uid)) {
                this.uids.add(uid.asLong());
                return;
            }
            if (this.contains(uid)) {
                return;
            }
            this.uids.add(uid.asLong());
            this.uids.sort(LongComparators.NATURAL_COMPARATOR);
        }
    }

    private boolean contains(MessageUid uid) {
        return this.getMsnUnsynchronized(uid).foldSilent(() -> false, any -> true);
    }

    private boolean isLastUid(MessageUid uid) {
        Optional<MessageUid> lastUid = this.getLastUid();
        return lastUid.isEmpty() || lastUid.get().compareTo(uid) < 0;
    }

    private int getLastMsn() {
        return this.getNumMessage();
    }
}

