/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.search.Combinator;

@JsonDeserialize(as=QueryDTO.class)
public class QueryDTO
implements QueryElement {
    private final String combinator;
    private final List<QueryElement> criteria;
    private final Optional<Long> limit;

    @VisibleForTesting
    static QueryDTO and(QueryElement ... queryElements) {
        return new QueryDTO(Combinator.AND.getValue(), (List<QueryElement>)ImmutableList.copyOf((Object[])queryElements), Optional.empty());
    }

    @VisibleForTesting
    static QueryDTO and(Long limit, QueryElement ... queryElements) {
        return new QueryDTO(Combinator.AND.getValue(), (List<QueryElement>)ImmutableList.copyOf((Object[])queryElements), Optional.ofNullable(limit));
    }

    @JsonCreator
    public QueryDTO(@JsonProperty(value="combinator") String combinator, @JsonProperty(value="criteria") List<QueryElement> criteria, @JsonProperty(value="limit") Optional<Long> limit) {
        this.combinator = combinator;
        this.criteria = criteria;
        this.limit = Optional.ofNullable(limit).orElse(Optional.empty());
    }

    public String getCombinator() {
        return this.combinator;
    }

    public List<QueryElement> getCriteria() {
        return this.criteria;
    }

    public Optional<Long> getLimit() {
        return this.limit;
    }

    public final boolean equals(Object o) {
        if (o instanceof QueryDTO) {
            QueryDTO queryDTO = (QueryDTO)o;
            return Objects.equals(this.combinator, queryDTO.getCombinator()) && Objects.equals(this.criteria, queryDTO.getCriteria()) && Objects.equals(this.limit, queryDTO.getLimit());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.combinator, this.criteria, this.limit);
    }
}

