/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class ArrayConcat<T>
extends AbstractField<T[]>
implements QOM.ArrayConcat<T> {
    final Field<T[]> array1;
    final Field<T[]> array2;

    ArrayConcat(Field<T[]> array1, Field<T[]> array2) {
        super(Names.N_ARRAY_CONCAT, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array1, false), array1, array2));
        this.array1 = Tools.nullSafeNotNull(array1, SQLDataType.OTHER.array());
        this.array2 = Tools.nullSafeNotNull(array2, SQLDataType.OTHER.array());
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_arrayConcat, this.getDataType(), this.array1, this.array2));
                break;
            }
            default: {
                ctx.sql('(').visit(this.array1).sql(" || ").visit(this.array2).sql(')');
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array1;
    }

    @Override
    public final Field<T[]> $arg2() {
        return this.array2;
    }

    @Override
    public final QOM.ArrayConcat<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T[]>)this.$arg2());
    }

    @Override
    public final QOM.ArrayConcat<T> $arg2(Field<T[]> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T[]>, ? extends QOM.ArrayConcat<T>> $constructor() {
        return (a1, a2) -> new ArrayConcat((Field<T[]>)a1, (Field<T[]>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayConcat) {
            QOM.ArrayConcat o = (QOM.ArrayConcat)that;
            return StringUtils.equals(this.$array1(), o.$array1()) && StringUtils.equals(this.$array2(), o.$array2());
        }
        return super.equals(that);
    }
}

