/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class CASWriteUnknown
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;

    public CASWriteUnknown(String message, int consistencyLevel, int received, int blockFor) {
        super(5888, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(5888, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            CASWriteUnknown readTimeout = (CASWriteUnknown)message;
            encoder.writeString(readTimeout.message, dest);
            encoder.writeUnsignedShort(readTimeout.consistencyLevel, dest);
            encoder.writeInt(readTimeout.received, dest);
            encoder.writeInt(readTimeout.blockFor, dest);
        }

        @Override
        public int encodedSize(Message message) {
            CASWriteUnknown readTimeout = (CASWriteUnknown)message;
            return PrimitiveSizes.sizeOfString(readTimeout.message) + 2 + 4 + 4;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            int consistencyLevel = decoder.readUnsignedShort(source);
            int received = decoder.readInt(source);
            int blockFor = decoder.readInt(source);
            return new CASWriteUnknown(message, consistencyLevel, received, blockFor);
        }
    }
}

