/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraTableManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTableManager.class);
    private final CqlSession session;
    private final CassandraDataDefinition module;

    @Inject
    public CassandraTableManager(CassandraDataDefinition module, CqlSession session) {
        this.session = session;
        this.module = module;
    }

    public CassandraTable.InitializationStatus initializeTables(CassandraTypesProvider typesProvider) {
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)this.session.getMetadata().getKeyspaces().get(this.session.getKeyspace().get());
        LOGGER.info("Enforcing the existance of the following tables: {}", (Object)this.module.moduleTables().stream().map(CassandraTable::getName).collect(Collectors.joining(", ")));
        return (CassandraTable.InitializationStatus)((Object)Flux.fromIterable(this.module.moduleTables()).flatMap(table -> table.initialize(keyspaceMetadata, this.session, typesProvider), 16).reduce(CassandraTable.InitializationStatus::reduce).switchIfEmpty(Mono.just((Object)((Object)CassandraTable.InitializationStatus.ALREADY_DONE))).block());
    }

    public void clearTables(Predicate<CassandraTable> condition) {
        CassandraAsyncExecutor executor = new CassandraAsyncExecutor(this.session);
        Flux.fromIterable(this.module.moduleTables()).filter(condition).publishOn(Schedulers.boundedElastic()).map(CassandraTable::getName).flatMap(name -> this.truncate(executor, (String)name), 16).then().block();
    }

    private Mono<Void> truncate(CassandraAsyncExecutor executor, String name) {
        return executor.executeRows((Statement)QueryBuilder.selectFrom((String)name).all().limit(1).build()).next().flatMap(ignored -> executor.executeVoid((Statement)QueryBuilder.truncate((String)name).build())).onErrorResume(e -> executor.executeVoid((Statement)QueryBuilder.truncate((String)name).build()));
    }
}

