/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;

class UpgradeResponseDelegate
implements UpgradeResponse {
    private final ServerUpgradeResponse response;
    private final Map<String, List<String>> headers;

    UpgradeResponseDelegate(ServerUpgradeResponse response) {
        this.response = response;
        this.headers = HttpFields.asMap((HttpFields)response.getHeaders());
    }

    public String getAcceptedSubProtocol() {
        return this.response.getAcceptedSubProtocol();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.response.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.response.getHeaders().get(name);
    }

    public Set<String> getHeaderNames() {
        return this.response.getHeaders().getFieldNamesCollection();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        return this.response.getHeaders().getValuesList(name);
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }
}

