/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.CoreDataModule;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.cassandra.CassandraDomainList;
import org.apache.james.domainlist.cassandra.CassandraDomainListDataDefinition;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class CassandraDomainListModule
extends AbstractModule {
    public void configure() {
        this.install((Module)new CoreDataModule());
        this.bind(CassandraDomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(CassandraDomainList.class);
        Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class).addBinding().toInstance((Object)CassandraDomainListDataDefinition.MODULE);
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration configuration, CassandraDomainList cassandraDomainList) {
        return InitilizationOperationBuilder.forClass(CassandraDomainList.class).init(() -> cassandraDomainList.configure(configuration));
    }
}

