/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventId$;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.History$;
import org.apache.james.eventsourcing.eventstore.JsonEventSerializer;
import org.apache.james.eventsourcing.eventstore.cassandra.CassandraEventStoreTable$;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u0014(\u0001QB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005{!Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003Q\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001d!\u0007A1A\u0005\n\u0015Daa\u001c\u0001!\u0002\u00131\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007q\u0002\u0001\u000b\u0011\u0002:\t\u000fe\u0004!\u0019!C\u0005c\"1!\u0010\u0001Q\u0001\nIDqa\u001f\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004}\u0001\u0001\u0006IA\u001d\u0005\b{\u0002\u0011\r\u0011\"\u0003r\u0011\u0019q\b\u0001)A\u0005e\"9q\u0010\u0001b\u0001\n\u0013\t\bbBA\u0001\u0001\u0001\u0006IA\u001d\u0005\t\u0003\u0007\u0001!\u0019!C\u0005c\"9\u0011Q\u0001\u0001!\u0002\u0013\u0011\b\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0011!\t9\u0002\u0001Q\u0001\n\u0005-\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u00022\u0001!I!a\r\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!A\u0011Q\b\u0001\u0005\u0002\u001d\ny\u0004C\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"1\u0011\u0010\u0001C\u0005\u0003\u0003D\u0001\"!5\u0001\t\u00039\u00131\u001b\u0005\t\u0003#\u0004A\u0011A\u0014\u0002`\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\b\u0002CA\u0000\u0001\u0011\u0005qE!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!Q\u0003\u0001\u0005\n\t]!!D#wK:$8\u000b^8sK\u0012\u000bwN\u0003\u0002)S\u0005I1-Y:tC:$'/\u0019\u0006\u0003U-\n!\"\u001a<f]R\u001cHo\u001c:f\u0015\taS&A\u0007fm\u0016tGo]8ve\u000eLgn\u001a\u0006\u0003]=\nQA[1nKNT!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011C\u0001\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u000691/Z:tS>tW#A\u001f\u0011\u0005yZU\"A \u000b\u0005\u0001\u000b\u0015\u0001B2pe\u0016T!AQ\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002E\u000b\u00061AM]5wKJT!AR$\u0002\u0007=\u001c8O\u0003\u0002I\u0013\u0006AA-\u0019;bgR\f\u0007PC\u0001K\u0003\r\u0019w.\\\u0005\u0003\u0019~\u0012!bQ9m'\u0016\u001c8/[8o\u0003!\u0019Xm]:j_:\u0004\u0013a\u00056t_:,e/\u001a8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014X#\u0001)\u0011\u0005E\u0013V\"A\u0015\n\u0005MK#a\u0005&t_:,e/\u001a8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u00066t_:,e/\u001a8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004/fS\u0006C\u0001-\u0001\u001b\u00059\u0003\"B\u001e\u0006\u0001\u0004i\u0004\"\u0002(\u0006\u0001\u0004\u0001\u0006FA\u0003]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0004j]*,7\r\u001e\u0006\u0002C\u00069!.Y6beR\f\u0017BA2_\u0005\u0019IeN[3di\u000612-Y:tC:$'/Y!ts:\u001cW\t_3dkR|'/F\u0001g!\t9W.D\u0001i\u0015\tI'.A\u0003vi&d7O\u0003\u0002)W*\u0011A.L\u0001\tE\u0006\u001c7.\u001a8eg&\u0011a\u000e\u001b\u0002\u0017\u0007\u0006\u001c8/\u00198ee\u0006\f5/\u001f8d\u000bb,7-\u001e;pe\u000692-Y:tC:$'/Y!ts:\u001cW\t_3dkR|'\u000fI\u0001\u0007S:\u001cXM\u001d;\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!^ \u0002\u0007\r\fH.\u0003\u0002xi\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0002\u000f%t7/\u001a:uA\u0005q\u0011N\\:feR\u001cf.\u00199tQ>$\u0018aD5og\u0016\u0014Ho\u00158baNDw\u000e\u001e\u0011\u0002\rM,G.Z2u\u0003\u001d\u0019X\r\\3di\u0002\n!b]3mK\u000e$hI]8n\u0003-\u0019X\r\\3di\u001a\u0013x.\u001c\u0011\u0002\u001dM,G.Z2u':\f\u0007o\u001d5pi\u0006y1/\u001a7fGR\u001cf.\u00199tQ>$\b%A\neK2,G/\u001a\"z\u0003\u001e<'/Z4bi\u0016LE-\u0001\u000beK2,G/\u001a\"z\u0003\u001e<'/Z4bi\u0016LE\rI\u0001\u0011Kb,7-\u001e;j_:\u0004&o\u001c4jY\u0016,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005@\u0003\u0019\u0019wN\u001c4jO&!\u0011QCA\b\u0005Y!%/\u001b<fe\u0016CXmY;uS>t\u0007K]8gS2,\u0017!E3yK\u000e,H/[8o!J|g-\u001b7fA\u0005i\u0001O]3qCJ,\u0017J\\:feR$2A]A\u000f\u0011\u0015Yd\u00031\u0001>\u0003U\u0001(/\u001a9be\u0016Len]3siNs\u0017\r]:i_R$2A]A\u0012\u0011\u0015Yt\u00031\u0001>\u00035\u0001(/\u001a9be\u0016\u001cV\r\\3diR\u0019!/!\u000b\t\u000bmB\u0002\u0019A\u001f\u0002+A\u0014X\r]1sKN+G.Z2u':\f\u0007o\u001d5piR\u0019!/a\f\t\u000bmJ\u0002\u0019A\u001f\u0002#A\u0014X\r]1sKN+G.Z2u\rJ|W\u000eF\u0002s\u0003kAQa\u000f\u000eA\u0002u\nQ\u0002\u001d:fa\u0006\u0014X\rR3mKR,Gc\u0001:\u0002<!)1h\u0007a\u0001{\u0005I\u0011\r\u001d9f]\u0012\fE\u000e\u001c\u000b\u0007\u0003\u0003\nY&a \u0011\r\u0005\r\u0013\u0011KA+\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!\u00039vE2L7\u000f[3s\u0015\rA\u00141\n\u0006\u0004\u0001\u00065#BAA(\u0003\u001d\u0011X-Y2u_JLA!a\u0015\u0002F\t)1+T8o_B\u0019a'a\u0016\n\u0007\u0005esGA\u0004C_>dW-\u00198\t\u000f\u0005uC\u00041\u0001\u0002`\u00051QM^3oiN\u0004b!!\u0019\u0002r\u0005]d\u0002BA2\u0003[rA!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S\u001a\u0014A\u0002\u001fs_>$h(C\u00019\u0013\r\tygN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019(!\u001e\u0003\u0011%#XM]1cY\u0016T1!a\u001c8!\u0011\tI(a\u001f\u000e\u0003-J1!! ,\u0005\u0015)e/\u001a8u\u0011\u001d\t\t\t\ba\u0001\u0003\u0007\u000bA\u0002\\1tiNs\u0017\r]*i_R\u0004RANAC\u0003\u0013K1!a\"8\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011PAF\u0013\r\tii\u000b\u0002\b\u000bZ,g\u000e^%e\u0003-\t\u0007\u000f]3oIF+XM]=\u0015\t\u0005M\u0015\u0011\u0017\u0019\u0005\u0003+\u000by\nE\u0003t\u0003/\u000bY*C\u0002\u0002\u001aR\u0014\u0011b\u0015;bi\u0016lWM\u001c;\u0011\t\u0005u\u0015q\u0014\u0007\u0001\t-\t\t+HA\u0001\u0002\u0003\u0015\t!a)\u0003\u0007}#\u0013'\u0005\u0003\u0002&\u0006-\u0006c\u0001\u001c\u0002(&\u0019\u0011\u0011V\u001c\u0003\u000f9{G\u000f[5oOB\u0019a'!,\n\u0007\u0005=vGA\u0002B]fDq!!\u0018\u001e\u0001\u0004\ty&A\u0006j]N,'\u000f^#wK:$H\u0003BA\\\u0003{\u00032a]A]\u0013\r\tY\f\u001e\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u001d\tyL\ba\u0001\u0003o\nQ!\u001a<f]R$b!a.\u0002D\u00065\u0007bBAc?\u0001\u0007\u0011qY\u0001\fC\u001e<'/Z4bi\u0016LE\r\u0005\u0003\u0002z\u0005%\u0017bAAfW\tY\u0011iZ4sK\u001e\fG/Z%e\u0011\u001d\tym\ba\u0001\u0003\u0013\u000b!b\u001d8baNDw\u000e^%e\u0003Q9W\r^#wK:$8o\u00144BO\u001e\u0014XmZ1uKR!\u0011Q[Ao!\u0019\t\u0019%!\u0015\u0002XB\u0019\u0011+!7\n\u0007\u0005m\u0017FA\u0004ISN$xN]=\t\u000f\u0005\u0015\u0007\u00051\u0001\u0002HR1\u0011Q[Aq\u0003GDq!!2\"\u0001\u0004\t9\rC\u0004\u0002P\u0006\u0002\r!!#\u0002\u0013\u0005\u001c\b*[:u_JLH\u0003BAk\u0003SDq!a;#\u0001\u0004\ti/\u0001\u0003s_^\u001c\bCBAx\u0003k\fI0\u0004\u0002\u0002r*\u0019\u00111_\u0019\u0002\u001fI,\u0017m\u0019;jm\u0016\u001cHO]3b[NLA!a>\u0002r\nI\u0001+\u001e2mSNDWM\u001d\t\u0004g\u0006m\u0018bAA\u007fi\n\u0019!k\\<\u0002\u0017\u001d,Go\u00158baNDw\u000e\u001e\u000b\u0005\u0005\u0007\u0011)\u0001\u0005\u0004\u0002D\u0005E\u0013\u0011\u0012\u0005\b\u0003\u000b\u001c\u0003\u0019AAd\u0003\u0019!W\r\\3uKR!!1\u0002B\n!\u0019\t\u0019%!\u0015\u0003\u000eA\u0019aGa\u0004\n\u0007\tEqG\u0001\u0003V]&$\bbBAcI\u0001\u0007\u0011qY\u0001\bi>,e/\u001a8u)\u0011\u0011IBa\u0007\u0011\r\u0005\r\u0013\u0011KA<\u0011\u001d\u0011i\"\na\u0001\u0003s\f1A]8x\u0001")
public class EventStoreDao {
    private final CqlSession session;
    private final JsonEventSerializer jsonEventSerializer;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertSnapshot;
    private final PreparedStatement select;
    private final PreparedStatement selectFrom;
    private final PreparedStatement selectSnapshot;
    private final PreparedStatement deleteByAggregateId;
    private final DriverExecutionProfile executionProfile;

    public CqlSession session() {
        return this.session;
    }

    public JsonEventSerializer jsonEventSerializer() {
        return this.jsonEventSerializer;
    }

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private PreparedStatement insert() {
        return this.insert;
    }

    private PreparedStatement insertSnapshot() {
        return this.insertSnapshot;
    }

    private PreparedStatement select() {
        return this.select;
    }

    private PreparedStatement selectFrom() {
        return this.selectFrom;
    }

    private PreparedStatement selectSnapshot() {
        return this.selectSnapshot;
    }

    private PreparedStatement deleteByAggregateId() {
        return this.deleteByAggregateId;
    }

    private DriverExecutionProfile executionProfile() {
        return this.executionProfile;
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).value(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT_ID(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT())).ifNotExists().build());
    }

    private PreparedStatement prepareInsertSnapshot(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.update((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).setColumn(CassandraEventStoreTable$.MODULE$.SNAPSHOT(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.SNAPSHOT())).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.EVENT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelectSnapshot(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.SNAPSHOT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    private PreparedStatement prepareSelectFrom(CqlSession session) {
        return session.prepare(((BuildableQuery)((OngoingWhereClause)QueryBuilder.selectFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).column(CassandraEventStoreTable$.MODULE$.EVENT()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).whereColumn(CassandraEventStoreTable$.MODULE$.EVENT_ID()).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.EVENT_ID()))).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((BuildableQuery)QueryBuilder.deleteFrom((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).whereColumn(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))).build());
    }

    public SMono<Object> appendAll(Iterable<Event> events, Option<EventId> lastSnapShot) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeReturnApplied(this.appendQuery(events)).map(x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1))).flatMap((Function1 & Serializable)success -> EventStoreDao.$anonfun$appendAll$2(this, lastSnapShot, events, BoxesRunTime.unboxToBoolean((Object)success)));
    }

    private Statement<?> appendQuery(Iterable<Event> events) {
        if (events.size() == 1) {
            return this.insertEvent((Event)events.head());
        }
        BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.LOGGED);
        events.foreach((Function1 & Serializable)event -> batch.addStatement((BatchableStatement)this.insertEvent((Event)event)));
        return batch.build();
    }

    private BoundStatement insertEvent(Event event) {
        return (BoundStatement)this.insert().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), event.getAggregateId().asAggregateKey()).setInt(CassandraEventStoreTable$.MODULE$.EVENT_ID(), event.eventId().serialize()).setString(CassandraEventStoreTable$.MODULE$.EVENT(), this.jsonEventSerializer().serialize(event));
    }

    private BoundStatement insertSnapshot(AggregateId aggregateId, EventId snapshotId) {
        return (BoundStatement)this.insertSnapshot().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), aggregateId.asAggregateKey()).setInt(CassandraEventStoreTable$.MODULE$.SNAPSHOT(), snapshotId.serialize());
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.asHistory((Publisher<Row>)this.cassandraAsyncExecutor().executeRows(((Statement)this.select().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT)).setExecutionProfile(this.executionProfile())));
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId, EventId snapshotId) {
        return this.asHistory((Publisher<Row>)this.cassandraAsyncExecutor().executeRows(((Statement)this.selectFrom().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT).setInt(CassandraEventStoreTable$.MODULE$.EVENT_ID(), snapshotId.value())).setExecutionProfile(this.executionProfile())));
    }

    private SMono<History> asHistory(Publisher<Row> rows) {
        SFlux qual$1 = SFlux$.MODULE$.apply(rows);
        Function1 & Serializable x$1 = (Function1 & Serializable)row -> this.toEvent((Row)row);
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1 & Serializable)x$3 -> x$3.toList()).map((Function1 & Serializable)x$4 -> History$.MODULE$.of(x$4));
    }

    public SMono<EventId> getSnapshot(AggregateId aggregateId) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeSingleRow((Statement)this.selectSnapshot().bind(new Object[0]).set(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)aggregateId.asAggregateKey(), TypeCodecs.TEXT))).map((Function1 & Serializable)row -> EventId$.MODULE$.fromSerialized(Predef$.MODULE$.Integer2int((Integer)row.get(0, (TypeCodec)TypeCodecs.INT))));
    }

    public SMono<BoxedUnit> delete(AggregateId aggregateId) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeVoid((Statement)this.deleteByAggregateId().bind(new Object[0]).setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), aggregateId.asAggregateKey()))).then();
    }

    private SMono<Event> toEvent(Row row) {
        return SMono$.MODULE$.fromCallable(() -> this.jsonEventSerializer().deserialize((String)row.get(0, TypeCodecs.TEXT))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public static final /* synthetic */ SMono $anonfun$appendAll$2(EventStoreDao $this, Option lastSnapShot$1, Iterable events$1, boolean success) {
        return ((SMono)lastSnapShot$1.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)success)).map((Function1 & Serializable)id -> SMono$.MODULE$.apply((Publisher)$this.cassandraAsyncExecutor().executeVoid((Statement)$this.insertSnapshot(((Event)events$1.head()).getAggregateId(), (EventId)id)))).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty())).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)success)));
    }

    @Inject
    public EventStoreDao(CqlSession session, JsonEventSerializer jsonEventSerializer) {
        this.session = session;
        this.jsonEventSerializer = jsonEventSerializer;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.insertSnapshot = this.prepareInsertSnapshot(session);
        this.select = this.prepareSelect(session);
        this.selectFrom = this.prepareSelectFrom(session);
        this.selectSnapshot = this.prepareSelectSnapshot(session);
        this.deleteByAggregateId = this.prepareDelete(session);
        this.executionProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
    }
}

