/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;

public class EmptyList<E>
implements LinkedList<E> {
    private static final LinkedList EMPTY_LIST = new EmptyList();
    LinkedListIterator<E> emptyIterator = new LinkedListIterator<E>(){

        @Override
        public void repeat() {
        }

        @Override
        public E removeLastElement() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }
    };

    public static final <T> LinkedList<T> getEmptyList() {
        return EMPTY_LIST;
    }

    private EmptyList() {
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public void addHead(E e) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void addTail(E e) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public E get(int position) {
        throw new IndexOutOfBoundsException("position = " + position);
    }

    @Override
    public E poll() {
        return null;
    }

    @Override
    public LinkedListIterator<E> iterator() {
        return this.emptyIterator;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void clearID() {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setNodeStore(NodeStore<E> store) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public E removeWithID(String listID, long id) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void forEach(Consumer<E> consumer) {
    }
}

