/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.identity;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.DefaultIdentitySupplier;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityForbiddenDeleteException;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest;
import org.apache.james.jmap.api.identity.IdentityWithOrigin;
import org.apache.james.jmap.api.identity.IdentityWithOrigin$;
import org.apache.james.jmap.api.model.ForbiddenSendFromException;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!)\u0001\u0006\u0001C\u0001S!)a\u0007\u0001C\u0001o!)\u0011\u000b\u0001C\u0001%\")A\u000b\u0001C\u0005+\")1\u0010\u0001C\u0005y\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0002\u0013\u0013\u0012,g\u000e^5usJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\r\u001b\u0005A\u0011\u000eZ3oi&$\u0018P\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0005A\t\u0012\u0001\u00026nCBT!AE\n\u0002\u000b)\fW.Z:\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0012GV\u001cHo\\7JI\u0016tG/\u001b;z\t\u0006|\u0007CA\u0011#\u001b\u0005Y\u0011BA\u0012\f\u0005E\u0019Uo\u001d;p[&#WM\u001c;jif$\u0015iT\u0001\u0010S\u0012,g\u000e^5us\u001a\u000b7\r^8ssB\u0011\u0011EJ\u0005\u0003O-\u0011q\u0003R3gCVdG/\u00133f]RLG/_*vaBd\u0017.\u001a:\u0002\rqJg.\u001b;?)\rQ3\u0006\f\t\u0003C\u0001AQaH\u0002A\u0002\u0001BQ\u0001J\u0002A\u0002\u0015B#a\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014AB5oU\u0016\u001cGOC\u00014\u0003\u001dQ\u0017m[1si\u0006L!!\u000e\u0019\u0003\r%s'.Z2u\u0003\u0011\u0019\u0018M^3\u0015\u0007a\"E\nE\u0002:yyj\u0011A\u000f\u0006\u0003wU\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003{i\u0012\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0011!B7pI\u0016d\u0017BA\"A\u0005!IE-\u001a8uSRL\b\"B#\u0005\u0001\u00041\u0015\u0001B;tKJ\u0004\"a\u0012&\u000e\u0003!S!!S\t\u0002\t\r|'/Z\u0005\u0003\u0017\"\u0013\u0001\"V:fe:\fW.\u001a\u0005\u0006\u001b\u0012\u0001\rAT\u0001\u0010GJ,\u0017\r^5p]J+\u0017/^3tiB\u0011\u0011eT\u0005\u0003!.\u0011q#\u00133f]RLG/_\"sK\u0006$\u0018n\u001c8SKF,Xm\u001d;\u0002\t1L7\u000f\u001e\u000b\u0003qMCQ!R\u0003A\u0002\u0019\u000bQ\u0003\\5tiN+'O^3s'\u0016$\u0018\nZ3oi&$\u0018\u0010\u0006\u0002WuB\u0019qK\u00181\u000e\u0003aS!!\u0017.\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u000f\\\u0015\tIELC\u0001^\u0003\u001d\u0011X-Y2u_JL!a\u0018-\u0003\u000bMkuN\\8\u0011\ti\t7-]\u0005\u0003En\u0011a\u0001V;qY\u0016\u0014\u0004c\u00013l]:\u0011Q-\u001b\t\u0003Mni\u0011a\u001a\u0006\u0003Q^\ta\u0001\u0010:p_Rt\u0014B\u00016\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0004'\u0016$(B\u00016\u001c!\t9u.\u0003\u0002q\u0011\nYQ*Y5m\u0003\u0012$'/Z:t!\r\u0011xO\u0010\b\u0003gVt!A\u001a;\n\u0003qI!A^\u000e\u0002\u000fA\f7m[1hK&\u0011\u00010\u001f\u0002\u0005\u0019&\u001cHO\u0003\u0002w7!)QI\u0002a\u0001\r\u0006\u0011B.[:u\u0007V\u001cHo\\7JI\u0016tG/\u001b;z)\u0015i\u0018\u0011AA\u0002!\r9fPP\u0005\u0003\u007fb\u0013Qa\u0015$mkbDQ!R\u0004A\u0002\u0019Ca!!\u0002\b\u0001\u0004\u0019\u0017AF1wC&d\u0017M\u00197f\u001b\u0006LG.\u00113ee\u0016\u001c8/Z:\u0002\rU\u0004H-\u0019;f)!\tY!a\u0005\u0002\u0016\u0005}\u0001\u0003B\u001d=\u0003\u001b\u00012AGA\b\u0013\r\t\tb\u0007\u0002\u0005+:LG\u000fC\u0003F\u0011\u0001\u0007a\tC\u0004\u0002\u0018!\u0001\r!!\u0007\u0002\u0015%$WM\u001c;jifLE\rE\u0002@\u00037I1!!\bA\u0005)IE-\u001a8uSRL\u0018\n\u001a\u0005\b\u0003CA\u0001\u0019AA\u0012\u0003UIG-\u001a8uSRLX\u000b\u001d3bi\u0016\u0014V-];fgR\u00042!IA\u0013\u0013\r\t9c\u0003\u0002\u0016\u0013\u0012,g\u000e^5usV\u0003H-\u0019;f%\u0016\fX/Z:u\u0003\u0019!W\r\\3uKR1\u00111BA\u0017\u0003cAa!a\f\n\u0001\u00041\u0015\u0001C;tKJt\u0017-\\3\t\u000f\u0005M\u0012\u00021\u0001\u00026\u0005\u0019\u0011\u000eZ:\u0011\t\u0011\\\u0017\u0011\u0004")
public class IdentityRepository {
    private final CustomIdentityDAO customIdentityDao;
    private final DefaultIdentitySupplier identityFactory;

    public Publisher<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.identityFactory.userCanSendFrom(user, creationRequest.email()).filter((Function1 & Serializable)bool -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)bool))).flatMap((Function1 & Serializable)x$20 -> SMono$.MODULE$.apply(this.customIdentityDao.save(user, creationRequest))).switchIfEmpty(SMono$.MODULE$.error((Throwable)new ForbiddenSendFromException(creationRequest.email())));
    }

    public Publisher<Identity> list(Username user) {
        SFlux qual$1 = this.listServerSetIdentity(user).flatMapMany((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Set mailAddressSet = (Set)tuple2._1();
                List identityList = (List)tuple2._2();
                return this.listCustomIdentity(user, (Set<MailAddress>)mailAddressSet).map((Function1 & Serializable)identity -> IdentityWithOrigin$.MODULE$.fromCustom((Identity)identity)).mergeWith((Publisher)SFlux$.MODULE$.fromIterable((Iterable)identityList).map((Function1 & Serializable)identity -> IdentityWithOrigin$.MODULE$.fromServerSet((Identity)identity)));
            }
            throw new MatchError((Object)tuple2);
        }).groupBy((Function1 & Serializable)x$21 -> x$21.identity().id());
        Function1 & Serializable x$1 = (Function1 & Serializable)x$22 -> x$22.reduce((Function2 & Serializable)(value1, value2) -> IdentityWithOrigin$.MODULE$.merge((IdentityWithOrigin.IdentityWithOrigin)value1, (IdentityWithOrigin.IdentityWithOrigin)value2));
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)x$23 -> x$23.identity());
    }

    private SMono<Tuple2<Set<MailAddress>, List<Identity>>> listServerSetIdentity(Username user) {
        return SFlux$.MODULE$.apply(this.identityFactory.listIdentities(user)).collectSeq().map((Function1 & Serializable)s -> s.toList()).map((Function1 & Serializable)list -> new Tuple2((Object)list.map((Function1 & Serializable)x$24 -> x$24.email()).toSet(), list));
    }

    private SFlux<Identity> listCustomIdentity(Username user, Set<MailAddress> availableMailAddresses) {
        return SFlux$.MODULE$.fromPublisher(this.customIdentityDao.list(user)).filter((Function1 & Serializable)identity -> BoxesRunTime.boxToBoolean((boolean)availableMailAddresses.contains((Object)identity.email())));
    }

    public Publisher<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdateRequest identityUpdateRequest) {
        SMono findServerSetIdentity = SFlux$.MODULE$.apply(this.identityFactory.listIdentities(user)).collectSeq().map((Function1 & Serializable)s -> s.toList()).map((Function1 & Serializable)list -> list.find((Function1 & Serializable)identity -> BoxesRunTime.boxToBoolean((boolean)IdentityRepository.$anonfun$update$4(identityId, identity))));
        SMono findCustomIdentity = SMono$.MODULE$.apply(this.customIdentityDao.findByIdentityId(user, identityId)).map((Function1 & Serializable)x$25 -> new Some(x$25)).switchIfEmpty(SMono$.MODULE$.just((Object)None$.MODULE$));
        return SFlux$.MODULE$.zip((Publisher)findServerSetIdentity, (Publisher)findCustomIdentity).next().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return SMono$.MODULE$.error((Throwable)new IdentityNotFoundException(identityId));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && option3 instanceof Some) {
                    Some some = (Some)option3;
                    Identity customIdentity = (Identity)some.value();
                    return $this.customIdentityDao.upsert(user, identityUpdateRequest.update(customIdentity));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Identity serverSetIdentity = (Identity)some.value();
                    if (None$.MODULE$.equals(option4)) {
                        return SMono$.MODULE$.apply($this.customIdentityDao.save(user, identityId, identityUpdateRequest.asCreationRequest(serverSetIdentity.email(), false)));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option5 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option5 instanceof Some) {
                    Some some = (Some)option5;
                    Identity customIdentity = (Identity)some.value();
                    return $this.identityFactory.userCanSendFrom(user, customIdentity.email()).filter((Function1 & Serializable)bool -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)bool))).switchIfEmpty(SMono$.MODULE$.error((Throwable)new IdentityNotFoundException(identityId))).flatMap((Function1 & Serializable)x$26 -> SMono$.MODULE$.apply(this.customIdentityDao.upsert(user, identityUpdateRequest.update(customIdentity))));
                }
            }
            throw new MatchError((Object)tuple2);
        }).then();
    }

    public Publisher<BoxedUnit> delete(Username username, Set<IdentityId> ids2) {
        return SFlux$.MODULE$.apply(this.identityFactory.listIdentities(username)).map((Function1 & Serializable)x$27 -> x$27.id()).collectSeq().flatMapMany((Function1 & Serializable)serverSetIdentities -> SFlux$.MODULE$.fromIterable((Iterable)ids2).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            IdentityRepository.$anonfun$delete$3(serverSetIdentities, x0$1, x1$1);
            return BoxedUnit.UNIT;
        })).collectSeq().flatMap((Function1 & Serializable)ids -> SMono$.MODULE$.fromPublisher($this.customIdentityDao.delete(username, (Set<IdentityId>)ids.toSet())));
    }

    public static final /* synthetic */ boolean $anonfun$update$4(IdentityId identityId$1, Identity identity) {
        return identity.id().equals(identityId$1);
    }

    public static final /* synthetic */ void $anonfun$delete$3(Seq serverSetIdentities$1, IdentityId x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            IdentityId id = (IdentityId)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            if (serverSetIdentities$1.contains((Object)id)) {
                sink.error((Throwable)new IdentityForbiddenDeleteException(id));
                return;
            }
            sink.next((Object)id);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public IdentityRepository(CustomIdentityDAO customIdentityDao, DefaultIdentitySupplier identityFactory) {
        this.customIdentityDao = customIdentityDao;
        this.identityFactory = identityFactory;
    }
}

