/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.model;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;

public class EnqueuedItemWithSlicingContext
implements Disposable {
    private final EnqueuedItem enqueuedItem;
    private final SlicingContext slicingContext;

    public static Builder.RequireEnqueuedItem builder() {
        return enqueuedItem -> slicingContext -> new Builder.ReadyToBuild(enqueuedItem, slicingContext);
    }

    private EnqueuedItemWithSlicingContext(EnqueuedItem enqueuedItem, SlicingContext slicingContext) {
        this.enqueuedItem = enqueuedItem;
        this.slicingContext = slicingContext;
    }

    public SlicingContext getSlicingContext() {
        return this.slicingContext;
    }

    public EnqueuedItem getEnqueuedItem() {
        return this.enqueuedItem;
    }

    public void dispose() {
        this.enqueuedItem.dispose();
    }

    public final boolean equals(Object o) {
        if (o instanceof EnqueuedItemWithSlicingContext) {
            EnqueuedItemWithSlicingContext that = (EnqueuedItemWithSlicingContext)o;
            return Objects.equals(this.slicingContext, that.slicingContext) && Objects.equals(this.enqueuedItem, that.enqueuedItem);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.slicingContext, this.enqueuedItem);
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final EnqueuedItem enqueuedItem;
            private final SlicingContext slicingContext;

            ReadyToBuild(EnqueuedItem enqueuedItem, SlicingContext slicingContext) {
                Preconditions.checkNotNull((Object)enqueuedItem, (Object)"'enqueuedItem' is mandatory.");
                Preconditions.checkNotNull((Object)slicingContext, (Object)"'slicingContext' is mandatory.");
                this.enqueuedItem = enqueuedItem;
                this.slicingContext = slicingContext;
            }

            public EnqueuedItemWithSlicingContext build() {
                return new EnqueuedItemWithSlicingContext(this.enqueuedItem, this.slicingContext);
            }
        }

        @FunctionalInterface
        public static interface RequireSlicingContext {
            public ReadyToBuild slicingContext(SlicingContext var1);
        }

        @FunctionalInterface
        public static interface RequireEnqueuedItem {
            public RequireSlicingContext enqueuedItem(EnqueuedItem var1);
        }
    }

    public static class SlicingContext {
        private final BucketedSlices.BucketId bucketId;
        private final Instant timeRangeStart;

        public static SlicingContext of(BucketedSlices.BucketId bucketId, Instant timeRangeStart) {
            return new SlicingContext(bucketId, timeRangeStart);
        }

        SlicingContext(BucketedSlices.BucketId bucketId, Instant timeRangeStart) {
            this.bucketId = bucketId;
            this.timeRangeStart = timeRangeStart;
        }

        public BucketedSlices.BucketId getBucketId() {
            return this.bucketId;
        }

        public Instant getTimeRangeStart() {
            return this.timeRangeStart;
        }

        public final boolean equals(Object o) {
            if (o instanceof SlicingContext) {
                SlicingContext that = (SlicingContext)o;
                return Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.timeRangeStart, that.timeRangeStart);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.bucketId, this.timeRangeStart);
        }
    }
}

