/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Box;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;

final class BoxCodec
extends AbstractGeometryCodec<Box> {
    BoxCodec(ByteBufAllocator byteBufAllocator) {
        super(Box.class, PostgresqlObjectId.BOX, byteBufAllocator);
    }

    @Override
    Box doDecodeBinary(ByteBuf buffer) {
        return Box.of(Point.of(buffer.readDouble(), buffer.readDouble()), Point.of(buffer.readDouble(), buffer.readDouble()));
    }

    @Override
    Box doDecodeText(String text) {
        AbstractGeometryCodec.TokenStream tokens = this.getTokenStream(text);
        return Box.of(Point.of(tokens.nextDouble(), tokens.nextDouble()), Point.of(tokens.nextDouble(), tokens.nextDouble()));
    }

    @Override
    ByteBuf doEncodeBinary(Box value) {
        return this.byteBufAllocator.buffer(32).writeDouble(value.getA().getX()).writeDouble(value.getA().getY()).writeDouble(value.getB().getX()).writeDouble(value.getB().getY());
    }

    @Override
    public String encodeToText(Box value) {
        return value.toString();
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.BOX_ARRAY;
    }
}

