/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.r2dbc.postgresql.codec.Json;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.StringBackedAttachmentId;
import org.apache.james.mailbox.postgres.mail.MessageRepresentation;
import org.jooq.BindingGetResultSetContext;
import org.jooq.BindingSetStatementContext;
import org.jooq.Converter;
import org.jooq.impl.AbstractConverter;
import org.jooq.postgres.extensions.bindings.AbstractPostgresBinding;

public class AttachmentsDTO
extends ArrayList<MessageRepresentation.AttachmentRepresentation>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static AttachmentsDTO from(List<MessageAttachmentMetadata> messageAttachmentMetadata) {
        return new AttachmentsDTO((Collection<? extends MessageRepresentation.AttachmentRepresentation>)MessageRepresentation.AttachmentRepresentation.from(messageAttachmentMetadata));
    }

    public AttachmentsDTO(Collection<? extends MessageRepresentation.AttachmentRepresentation> c) {
        super(c);
    }

    public static class AttachmentsDTOBinding
    extends AbstractPostgresBinding<Object, AttachmentsDTO> {
        private static final long serialVersionUID = 1L;
        private static final Converter<Object, AttachmentsDTO> CONVERTER = new AttachmentsDTOConverter();

        public Converter<Object, AttachmentsDTO> converter() {
            return CONVERTER;
        }

        public void set(BindingSetStatementContext<AttachmentsDTO> ctx) throws SQLException {
            Object value = ctx.convert(this.converter()).value();
            ctx.statement().setObject(ctx.index(), value == null ? null : value);
        }

        public void get(BindingGetResultSetContext<AttachmentsDTO> ctx) throws SQLException {
            ctx.convert(this.converter()).value((Object)((Json)ctx.resultSet().getObject(ctx.index())));
        }
    }

    public static class AttachmentsDTOConverter
    extends AbstractConverter<Object, AttachmentsDTO> {
        private static final long serialVersionUID = 1L;
        private static final String ATTACHMENT_ID_PROPERTY = "attachment_id";
        private static final String NAME_PROPERTY = "name";
        private static final String CID_PROPERTY = "cid";
        private static final String IN_LINE_PROPERTY = "in_line";
        private final ObjectMapper objectMapper = new ObjectMapper();

        public AttachmentsDTOConverter() {
            super(Object.class, AttachmentsDTO.class);
            this.objectMapper.registerModule((Module)new Jdk8Module());
        }

        public AttachmentsDTO from(Object databaseObject) {
            if (databaseObject instanceof Json) {
                try {
                    JsonNode arrayNode = this.objectMapper.readTree(((Json)databaseObject).asArray());
                    List collect = StreamSupport.stream(arrayNode.spliterator(), false).map(this::fromJsonNode).collect(Collectors.toList());
                    return new AttachmentsDTO(collect);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while deserializing attachment representation", e);
                }
            }
            throw new RuntimeException("Error while deserializing attachment representation. Unknown type: " + databaseObject.getClass().getName());
        }

        public Object to(AttachmentsDTO userObject) {
            try {
                byte[] jsonAsByte = this.objectMapper.writeValueAsBytes(userObject.stream().map(attachment -> Map.of(ATTACHMENT_ID_PROPERTY, attachment.getAttachmentId().getId(), NAME_PROPERTY, attachment.getName(), CID_PROPERTY, attachment.getCid().map(Cid::getValue), IN_LINE_PROPERTY, attachment.isInline())).collect(Collectors.toList()));
                return Json.of((byte[])jsonAsByte);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private MessageRepresentation.AttachmentRepresentation fromJsonNode(JsonNode jsonNode) {
            StringBackedAttachmentId attachmentId = StringBackedAttachmentId.from((String)jsonNode.get(ATTACHMENT_ID_PROPERTY).asText());
            Optional<String> name = Optional.ofNullable(jsonNode.get(NAME_PROPERTY)).map(JsonNode::asText);
            Optional<Cid> cid = Optional.ofNullable(jsonNode.get(CID_PROPERTY)).map(JsonNode::asText).map(Cid::from);
            boolean isInline = jsonNode.get(IN_LINE_PROPERTY).asBoolean();
            return new MessageRepresentation.AttachmentRepresentation((AttachmentId)attachmentId, name, cid, isInline);
        }
    }
}

