/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.CalendarInterval;
import org.opensearch.client.opensearch._types.aggregations.FormatMetricAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.RateMode;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RateAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final CalendarInterval unit;
    @Nullable
    private final RateMode mode;
    public static final JsonpDeserializer<RateAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RateAggregation::setupRateAggregationDeserializer);

    private RateAggregation(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.mode = builder.mode;
    }

    public static RateAggregation of(Function<Builder, ObjectBuilder<RateAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Rate;
    }

    @Nullable
    public final CalendarInterval unit() {
        return this.unit;
    }

    @Nullable
    public final RateMode mode() {
        return this.mode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    protected static void setupRateAggregationDeserializer(ObjectDeserializer<Builder> op) {
        RateAggregation.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::unit, CalendarInterval._DESERIALIZER, "unit");
        op.add(Builder::mode, RateMode._DESERIALIZER, "mode");
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RateAggregation> {
        @Nullable
        private CalendarInterval unit;
        @Nullable
        private RateMode mode;

        public final Builder unit(@Nullable CalendarInterval value) {
            this.unit = value;
            return this;
        }

        public final Builder mode(@Nullable RateMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RateAggregation build() {
            this._checkSingleUse();
            return new RateAggregation(this);
        }
    }
}

