/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.JSON;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONGetAttributeAsText
extends AbstractField<String>
implements QOM.JSONGetAttributeAsText {
    final Field<JSON> field;
    final Field<String> attribute;

    JSONGetAttributeAsText(Field<JSON> field, Field<String> attribute) {
        super(Names.N_JSON_GET_ATTRIBUTE_AS_TEXT, Tools.allNotNull(SQLDataType.VARCHAR, field, attribute));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.JSON);
        this.attribute = Tools.nullSafeNotNull(attribute, SQLDataType.VARCHAR);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                return false;
            }
            case MARIADB: {
                return false;
            }
            case SQLITE: {
                return false;
            }
            case CLICKHOUSE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSON, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, this.field, DSL.inline("$.").concat(this.attribute)), DSL.inline("null").cast(SQLDataType.JSON))));
                break;
            }
            case MARIADB: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSON, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, this.field, DSL.inline("$.").concat(this.attribute)).cast(SQLDataType.VARCHAR), DSL.inline("null"))));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, this.field, DSL.inline("$.").concat(this.attribute)));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_JSONExtractString, this.getDataType(), this.field, this.attribute));
                break;
            }
            default: {
                ctx.sql('(').visit(this.field).sql("->>").visit(this.attribute).sql(')');
            }
        }
    }

    @Override
    public final Field<JSON> $arg1() {
        return this.field;
    }

    @Override
    public final Field<String> $arg2() {
        return this.attribute;
    }

    @Override
    public final QOM.JSONGetAttributeAsText $arg1(Field<JSON> newValue) {
        return this.$constructor().apply((Field<JSON>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.JSONGetAttributeAsText $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<JSON>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<JSON>, ? super Field<String>, ? extends QOM.JSONGetAttributeAsText> $constructor() {
        return (a1, a2) -> new JSONGetAttributeAsText((Field<JSON>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONGetAttributeAsText) {
            QOM.JSONGetAttributeAsText o = (QOM.JSONGetAttributeAsText)that;
            return StringUtils.equals(this.$field(), o.$field()) && StringUtils.equals(this.$attribute(), o.$attribute());
        }
        return super.equals(that);
    }
}

