/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StoreSubscriptionManager
implements SubscriptionManager {
    private static final int INITIAL_SIZE = 32;
    protected SubscriptionMapperFactory mapperFactory;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final EventBus eventBus;

    @Inject
    public StoreSubscriptionManager(SubscriptionMapperFactory mapperFactory, MailboxSessionMapperFactory mailboxSessionMapperFactory, EventBus eventBus) {
        this.mapperFactory = mapperFactory;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.eventBus = eventBus;
    }

    public void subscribe(MailboxSession session, MailboxPath mailbox) throws SubscriptionException {
        SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(Mapper.toTransaction(() -> {
                Subscription newSubscription = new Subscription(session.getUser(), mailbox.asEscapedString());
                mapper.save(newSubscription);
            }));
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
        this.dispatchSubscribedEvent(session, mailbox).block();
    }

    public Publisher<Void> subscribeReactive(MailboxPath mailbox, MailboxSession session) {
        try {
            SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
            Subscription newSubscription = new Subscription(session.getUser(), mailbox.asEscapedString());
            return mapper.executeReactive(mapper.saveReactive(newSubscription)).then(this.dispatchSubscribedEvent(session, mailbox));
        }
        catch (SubscriptionException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> dispatchSubscribedEvent(MailboxSession session, MailboxPath mailboxPath) {
        return this.mailboxSessionMapperFactory.getMailboxMapper(session).findMailboxByPath(mailboxPath).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.MailboxSubscribedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxSubscribed().randomEventId()).mailboxSession(session)).mailbox((Mailbox)mailbox)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())));
    }

    public Publisher<Void> unsubscribeReactive(MailboxPath mailbox, MailboxSession session) {
        try {
            SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
            Subscription oldSubscription = new Subscription(session.getUser(), mailbox.asEscapedString());
            Optional<Subscription> legacyOldSubscription = Optional.of(new Subscription(session.getUser(), mailbox.getName())).filter(any -> mailbox.belongsTo(session));
            return mapper.executeReactive(mapper.deleteReactive(oldSubscription)).then(legacyOldSubscription.map(subscription -> mapper.executeReactive(mapper.deleteReactive((Subscription)subscription))).orElse(Mono.empty())).then(this.dispatchUnSubscribedEvent(session, mailbox));
        }
        catch (SubscriptionException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Collection<MailboxPath> subscriptions(MailboxSession session) throws SubscriptionException {
        return this.mapperFactory.getSubscriptionMapper(session).findSubscriptionsForUser(session.getUser()).stream().map(Subscription::getMailbox).map(s -> MailboxPath.parseEscaped((String)s).orElse(MailboxPath.forUser((Username)session.getUser(), (String)s))).collect(Collectors.toCollection(() -> new HashSet(32)));
    }

    public Publisher<MailboxPath> subscriptionsReactive(MailboxSession session) throws SubscriptionException {
        return this.mapperFactory.getSubscriptionMapper(session).findSubscriptionsForUserReactive(session.getUser()).map(Subscription::getMailbox).map(s -> MailboxPath.parseEscaped((String)s).orElse(MailboxPath.forUser((Username)session.getUser(), (String)s)));
    }

    public void unsubscribe(MailboxSession session, MailboxPath mailbox) throws SubscriptionException {
        SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(Mapper.toTransaction(() -> mapper.delete(new Subscription(session.getUser(), mailbox.asEscapedString()))));
            if (mailbox.belongsTo(session)) {
                mapper.execute(Mapper.toTransaction(() -> mapper.delete(new Subscription(session.getUser(), mailbox.getName()))));
            }
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
        this.dispatchUnSubscribedEvent(session, mailbox).block();
    }

    private Mono<Void> dispatchUnSubscribedEvent(MailboxSession session, MailboxPath mailboxPath) {
        return this.mailboxSessionMapperFactory.getMailboxMapper(session).findMailboxByPath(mailboxPath).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.MailboxUnSubscribedFinalStage)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.mailboxUnSubscribed().randomEventId()).mailboxSession(session)).mailbox((Mailbox)mailbox)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())));
    }

    public void endProcessingRequest(MailboxSession session) {
        if (this.mapperFactory instanceof RequestAware) {
            ((RequestAware)this.mapperFactory).endProcessingRequest(session);
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }
}

