/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.select.ArithmeticSelector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class OppositeSelector
extends ArithmeticSelector {
    private final Selector argument;
    private final CqlIdentifier alias;

    public OppositeSelector(@NonNull Selector argument) {
        this(argument, null);
    }

    public OppositeSelector(@NonNull Selector argument, @Nullable CqlIdentifier alias) {
        super(ArithmeticOperator.OPPOSITE);
        Preconditions.checkNotNull((Object)argument);
        this.argument = argument;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new OppositeSelector(this.argument, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append('-');
        OppositeSelector.appendAndMaybeParenthesize(this.operator.getPrecedenceLeft(), this.argument, builder);
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getArgument() {
        return this.argument;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OppositeSelector) {
            OppositeSelector that = (OppositeSelector)other;
            return this.argument.equals(that.argument) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.argument, this.alias);
    }
}

