/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.text.ParsePosition;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.DateTimeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.RawBody;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.MimeParameterMapping;

public class ContentDispositionFieldLenientImpl
extends AbstractField
implements ContentDispositionField {
    private static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFieldLenientImpl.RFC_5322;
    private boolean parsed = false;
    private String dispositionType = "";
    private final MimeParameterMapping mapping = new MimeParameterMapping();
    private boolean creationDateParsed;
    private Date creationDate;
    private boolean modificationDateParsed;
    private Date modificationDate;
    private boolean readDateParsed;
    private Date readDate;
    public static final FieldParser<ContentDispositionField> PARSER = new FieldParser<ContentDispositionField>(){

        @Override
        public ContentDispositionField parse(Field rawField, DecodeMonitor monitor) {
            return new ContentDispositionFieldLenientImpl(rawField, monitor);
        }
    };

    ContentDispositionFieldLenientImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public String getDispositionType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType;
    }

    @Override
    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.mapping.get(name);
    }

    @Override
    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.mapping.getParameters());
    }

    @Override
    public boolean isDispositionType(String dispositionType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equalsIgnoreCase(dispositionType);
    }

    @Override
    public boolean isInline() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals("inline");
    }

    @Override
    public boolean isAttachment() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals("attachment");
    }

    @Override
    public String getFilename() {
        return this.getParameter("filename");
    }

    @Override
    public Date getCreationDate() {
        if (!this.creationDateParsed) {
            this.creationDate = this.parseDate("creation-date");
            this.creationDateParsed = true;
        }
        return this.creationDate;
    }

    @Override
    public Date getModificationDate() {
        if (!this.modificationDateParsed) {
            this.modificationDate = this.parseDate("modification-date");
            this.modificationDateParsed = true;
        }
        return this.modificationDate;
    }

    @Override
    public Date getReadDate() {
        if (!this.readDateParsed) {
            this.readDate = this.parseDate("read-date");
            this.readDateParsed = true;
        }
        return this.readDate;
    }

    @Override
    public long getSize() {
        String value = this.getParameter("size");
        if (value == null) {
            return -1L;
        }
        try {
            long size = Long.parseLong(value);
            return size < 0L ? -1L : size;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void parse() {
        this.parsed = true;
        RawField f = this.getRawField();
        RawBody body = RawFieldParser.DEFAULT.parseRawBody(f);
        String main = body.getValue();
        this.dispositionType = main != null ? main.toLowerCase(Locale.US) : null;
        for (NameValuePair pair : body.getParams()) {
            this.mapping.addParameter(pair.getName(), pair.getValue());
        }
    }

    private Date parseDate(String paramName) {
        String value = this.getParameter(paramName);
        if (value == null) {
            return null;
        }
        try {
            return Date.from(Instant.from(DEFAULT_DATE_FORMAT.parse((CharSequence)value, new ParsePosition(0))));
        }
        catch (Exception ignore) {
            if (this.monitor.isListening()) {
                this.monitor.warn(paramName + " parameter is invalid: " + value, paramName + " parameter is ignored");
            }
            return null;
        }
    }
}

