/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayLimit
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelayLimit.class);
    int limit = 30;

    public void init() throws MessagingException {
        this.limit = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        MimeMessage mm = mail.getMessage();
        int count = 0;
        Enumeration e = mm.getAllHeaders();
        while (e.hasMoreElements()) {
            Header hdr = (Header)e.nextElement();
            if (!hdr.getName().equals("Received")) continue;
            ++count;
        }
        if (count >= this.limit) {
            LOGGER.error("{} with Message-ID {} exceeded relay limit: {} Received headers", new Object[]{mail.getName(), mail.getMessage().getMessageID(), count});
            return mail.getRecipients();
        }
        return null;
    }
}

