/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityRestriction;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityState;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetSubtreeAccessibilityExtendedResult
extends ExtendedResult {
    @NotNull
    public static final String GET_SUBTREE_ACCESSIBILITY_RESULT_OID = "1.3.6.1.4.1.30221.1.6.21";
    private static final byte TYPE_BASE_DN = -128;
    private static final byte TYPE_STATE = -127;
    private static final byte TYPE_BYPASS_USER = -126;
    private static final byte TYPE_EFFECTIVE_TIME = -125;
    private static final long serialVersionUID = -3163306122775326749L;
    @Nullable
    private final List<SubtreeAccessibilityRestriction> accessibilityRestrictions;

    public GetSubtreeAccessibilityExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.accessibilityRestrictions = null;
            return;
        }
        try {
            ASN1Element[] restrictionElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            ArrayList<SubtreeAccessibilityRestriction> restrictionList = new ArrayList<SubtreeAccessibilityRestriction>(restrictionElements.length);
            for (ASN1Element e : restrictionElements) {
                String baseDN = null;
                SubtreeAccessibilityState state = null;
                String bypassDN = null;
                Date effectiveTime = null;
                block10: for (ASN1Element re : ASN1Sequence.decodeAsSequence(e).elements()) {
                    switch (re.getType()) {
                        case -128: {
                            baseDN = ASN1OctetString.decodeAsOctetString(re).stringValue();
                            continue block10;
                        }
                        case -127: {
                            state = SubtreeAccessibilityState.valueOf(ASN1Enumerated.decodeAsEnumerated(re).intValue());
                            if (state != null) continue block10;
                            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_UNEXPECTED_STATE.get(ASN1Enumerated.decodeAsEnumerated(re).intValue()));
                        }
                        case -126: {
                            bypassDN = ASN1OctetString.decodeAsOctetString(re).stringValue();
                            continue block10;
                        }
                        case -125: {
                            effectiveTime = StaticUtils.decodeGeneralizedTime(ASN1OctetString.decodeAsOctetString(re).stringValue());
                            continue block10;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_UNEXPECTED_TYPE.get(StaticUtils.toHex(re.getType())));
                        }
                    }
                }
                if (baseDN == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_MISSING_BASE.get());
                }
                if (state == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_MISSING_STATE.get());
                }
                if (effectiveTime == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_MISSING_TIME.get());
                }
                restrictionList.add(new SubtreeAccessibilityRestriction(baseDN, state, bypassDN, effectiveTime));
            }
            this.accessibilityRestrictions = Collections.unmodifiableList(restrictionList);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUBTREE_ACCESSIBILITY_RESULT_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public GetSubtreeAccessibilityExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Collection<SubtreeAccessibilityRestriction> restrictions, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, GetSubtreeAccessibilityExtendedResult.encodeValue(restrictions), responseControls);
        this.accessibilityRestrictions = restrictions == null ? null : Collections.unmodifiableList(new ArrayList<SubtreeAccessibilityRestriction>(restrictions));
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable Collection<SubtreeAccessibilityRestriction> restrictions) {
        if (restrictions == null) {
            return null;
        }
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(restrictions.size());
        for (SubtreeAccessibilityRestriction r : restrictions) {
            ArrayList<ASN1Element> restrictionElements = new ArrayList<ASN1Element>(4);
            restrictionElements.add(new ASN1OctetString(-128, r.getSubtreeBaseDN()));
            restrictionElements.add(new ASN1Enumerated(-127, r.getAccessibilityState().intValue()));
            if (r.getBypassUserDN() != null) {
                restrictionElements.add(new ASN1OctetString(-126, r.getBypassUserDN()));
            }
            restrictionElements.add(new ASN1OctetString(-125, StaticUtils.encodeGeneralizedTime(r.getEffectiveTime())));
            elements.add(new ASN1Sequence(restrictionElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public List<SubtreeAccessibilityRestriction> getAccessibilityRestrictions() {
        return this.accessibilityRestrictions;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_GET_SUBTREE_ACCESSIBILITY.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GetSubtreeAccessibilityExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()) != null && referralURLs.length > 0) {
            buffer.append(", referralURLs={ '");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append("', '");
                }
                buffer.append(referralURLs[i]);
            }
            buffer.append("' }");
        }
        if (this.accessibilityRestrictions != null) {
            buffer.append(", accessibilityRestrictions={");
            Iterator<SubtreeAccessibilityRestriction> iterator = this.accessibilityRestrictions.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        if ((controls = this.getResponseControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

