/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogCtlJUL {
    public static String JUL_LOGGING = "logging.properties";
    private static String JUL_PROPERTY = "java.util.logging.configuration";
    static String defaultProperties = StrUtils.strjoinNL("handlers=org.apache.jena.atlas.logging.java.ConsoleHandlerStream");

    private LogCtlJUL() {
    }

    static String getLevelJUL(String logger) {
        Level level = Logger.getLogger(logger).getLevel();
        if (level == null) {
            return null;
        }
        if (level == Level.SEVERE) {
            return "ERROR";
        }
        return level.getName();
    }

    static void setLevelJUL(String logger, String levelName) {
        Level level = Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = Level.FINE;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = Level.WARNING;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = Level.SEVERE;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        }
        Logger.getLogger(logger).setLevel(level);
    }

    static void resetJavaLogging() {
        Path p = Path.of(JUL_LOGGING, new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            LogCtlJUL.setJavaLogging(JUL_LOGGING);
            return;
        }
        if (LogCtlJUL.setJavaLoggingClasspath(JUL_LOGGING)) {
            return;
        }
        LogCtlJUL.setJavaLoggingDft();
    }

    static void readJavaLoggingConfiguration(InputStream details) throws Exception {
        System.setProperty(JUL_PROPERTY, "set");
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();
        logManager.readConfiguration(details);
    }

    private static boolean setJavaLoggingClasspath(String resourceName) {
        InputStream in = LogCtl.class.getClassLoader().getResourceAsStream(resourceName);
        if (in != null) {
            try {
                LogCtlJUL.readJavaLoggingConfiguration(in);
                return true;
            }
            catch (Exception ex) {
                throw new AtlasException(ex);
            }
        }
        return false;
    }

    public static void setJavaLogging(String file) {
        try {
            InputStream details = new FileInputStream(file);
            details = new BufferedInputStream(details);
            LogCtlJUL.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static void setJavaLoggingDft() {
        try {
            ByteArrayInputStream details = new ByteArrayInputStream(defaultProperties.getBytes(StandardCharsets.UTF_8));
            LogCtlJUL.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static void noOutputJUL(Runnable action, String loggerName) {
        try {
            Logger logger = Logger.getLogger(loggerName);
            Level level = logger.getLevel();
            logger.setLevel(Level.OFF);
            action.run();
            logger.setLevel(level);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void routeJULtoSLF4J() {
        try {
            if (!SLF4JBridgeHandler.isInstalled()) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

