/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;

public class IteratorParsers {
    public static Iterator<Triple> createIteratorTriples(InputStream input, Lang lang, String baseURI) {
        Objects.requireNonNull(lang);
        if (Lang.NTRIPLES.equals(lang)) {
            return IteratorParsers.createIteratorNTriples(input);
        }
        if (!RDFLanguages.isTriples(lang)) {
            throw new RiotException("Not a triples syntax: " + lang.getName());
        }
        return AsyncParser.asyncParseTriples(input, lang, baseURI);
    }

    public static Iterator<Quad> createIteratorQuads(InputStream input, Lang lang, String baseURI) {
        Objects.requireNonNull(lang);
        if (Lang.NQUADS.equals(lang)) {
            return IteratorParsers.createIteratorNQuads(input);
        }
        return AsyncParser.asyncParseQuads(input, lang, baseURI);
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input) {
        return IteratorParsers.createIteratorNTriples(input, RiotLib.dftProfile());
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, ParserProfile profile) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        return IteratorParsers.createParserNTriples(tokenizer, null, profile);
    }

    static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNTriples parser = new LangNTriples(tokenizer, profile, dest);
        return parser;
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input) {
        return IteratorParsers.createIteratorNQuads(input, RiotLib.dftProfile());
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, ParserProfile profile) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        return IteratorParsers.createParserNQuads(tokenizer, null, profile);
    }

    static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNQuads parser = new LangNQuads(tokenizer, profile, dest);
        return parser;
    }
}

