/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.atlas.json;

public class JsonBoolean extends JsonPrimitive
{
    private final boolean bool ;
    
    public JsonBoolean(boolean bool)
    { this.bool = bool ; }
    
    @Override
    public boolean isBoolean()      { return true ; }
    @Override
    public JsonBoolean getAsBoolean() { return this ; }

    public boolean value()          { return bool ; }
    
    @Override
    public void visit(JsonVisitor visitor)
    { visitor.visit(this) ; }
    
    @Override
    public int hashCode()
    {
        return bool ? 9 : 11 ;
    }

    @Override
    public boolean equals(Object other)
    {
        if ( ! ( other instanceof JsonBoolean ) ) return false ;
        return ((JsonBoolean)other).bool == bool ; 
    }
}
