/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets.prefixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.Transactional;

public class PrefixesMap
implements PrefixesAccess {
    private final PrefixMap prefixMap;
    private final Transactional transactional;

    public PrefixesMap(PrefixMap prefixMap, Transactional transactional) {
        this.transactional = transactional;
        this.prefixMap = prefixMap;
    }

    @Override
    public Transactional transactional() {
        return this.transactional;
    }

    @Override
    public Optional<String> fetchURI(String prefix) {
        return Optional.ofNullable(this.prefixMap.get(prefix));
    }

    @Override
    public void updatePrefix(String prefix, String uri) {
        this.prefixMap.delete(prefix);
        this.prefixMap.add(prefix, uri);
    }

    @Override
    public void removePrefix(String prefixToRemove) {
        this.prefixMap.delete(prefixToRemove);
    }

    @Override
    public Map<String, String> getAll() {
        return this.prefixMap.getMapping();
    }

    @Override
    public List<String> fetchPrefix(String uri) {
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String prefix : this.prefixMap.getMapping().keySet()) {
            if (!this.prefixMap.getMapping().get(prefix).equals(uri)) continue;
            prefixList.add(prefix);
        }
        return prefixList;
    }
}

