/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;

public class FacetsCollector
extends SimpleCollector {
    private LeafReaderContext context;
    private Scorable scorer;
    private int totalHits;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private DocIdSetBuilder docsBuilder;

    public FacetsCollector() {
        this(false);
    }

    public FacetsCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public final boolean getKeepScores() {
        return this.keepScores;
    }

    public List<MatchingDocs> getMatchingDocs() {
        return this.matchingDocs;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.docsBuilder.grow(1).add(doc);
        if (this.keepScores) {
            if (this.totalHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize(this.totalHits + 1, 4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.scores.length);
                this.scores = newScores;
            }
            this.scores[this.totalHits] = this.scorer.score();
        }
        ++this.totalHits;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.keepScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public final void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context2) throws IOException {
        assert (this.docsBuilder == null);
        this.docsBuilder = new DocIdSetBuilder(context2.reader().maxDoc());
        this.totalHits = 0;
        if (this.keepScores) {
            this.scores = new float[64];
        }
        this.context = context2;
    }

    @Override
    public void finish() throws IOException {
        DocIdSet bits;
        if (this.docsBuilder != null) {
            bits = this.docsBuilder.build();
            this.docsBuilder = null;
        } else {
            bits = DocIdSet.EMPTY;
        }
        this.matchingDocs.add(new MatchingDocs(this.context, bits, this.totalHits, this.scores));
        this.scores = null;
        this.context = null;
    }

    @Deprecated
    public static TopDocs search(IndexSearcher searcher, Query q, int n, Collector fc) throws IOException {
        return FacetsCollector.doSearch(searcher, null, q, n, null, false, fc);
    }

    @Deprecated
    public static TopFieldDocs search(IndexSearcher searcher, Query q, int n, Sort sort, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return (TopFieldDocs)FacetsCollector.doSearch(searcher, null, q, n, sort, false, fc);
    }

    @Deprecated
    public static TopFieldDocs search(IndexSearcher searcher, Query q, int n, Sort sort, boolean doDocScores, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return (TopFieldDocs)FacetsCollector.doSearch(searcher, null, q, n, sort, doDocScores, fc);
    }

    @Deprecated
    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Collector fc) throws IOException {
        return FacetsCollector.doSearch(searcher, after, q, n, null, false, fc);
    }

    @Deprecated
    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollector.doSearch(searcher, after, q, n, sort, false, fc);
    }

    @Deprecated
    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollector.doSearch(searcher, after, q, n, sort, doDocScores, fc);
    }

    private static TopDocs doSearch(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, Collector fc) throws IOException {
        int limit = searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        n = Math.min(n, limit);
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        TopDocs topDocs = null;
        if (n == 0) {
            TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
            searcher.search(q, MultiCollector.wrap(totalHitCountCollector, fc));
            topDocs = new TopDocs(new TotalHits(totalHitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
        } else {
            TopDocsCollector hitsCollector;
            if (sort != null) {
                if (after != null && !(after instanceof FieldDoc)) {
                    throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
                }
                hitsCollector = TopFieldCollector.create(sort, n, (FieldDoc)after, Integer.MAX_VALUE);
            } else {
                hitsCollector = TopScoreDocCollector.create(n, after, Integer.MAX_VALUE);
            }
            searcher.search(q, MultiCollector.wrap(hitsCollector, fc));
            topDocs = hitsCollector.topDocs();
            if (doDocScores) {
                TopFieldCollector.populateScores(topDocs.scoreDocs, searcher, q);
            }
        }
        return topDocs;
    }

    public static final class MatchingDocs {
        public final LeafReaderContext context;
        public final DocIdSet bits;
        public final float[] scores;
        public final int totalHits;

        public MatchingDocs(LeafReaderContext context2, DocIdSet bits, int totalHits, float[] scores) {
            this.context = context2;
            this.bits = bits;
            this.scores = scores;
            this.totalHits = totalHits;
        }
    }
}

