/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.apache.shiro.crypto.hash.HashSpi;

public final class HashProvider {
    private HashProvider() {
    }

    public static Optional<HashSpi> getByAlgorithmName(String algorithmName) {
        Objects.requireNonNull(algorithmName, "algorithmName in HashProvider.getByAlgorithmName");
        ServiceLoader<HashSpi> hashSpis = HashProvider.load();
        return StreamSupport.stream(hashSpis.spliterator(), false).filter(hashSpi -> hashSpi.getImplementedAlgorithms().contains(algorithmName)).findAny();
    }

    private static ServiceLoader<HashSpi> load() {
        return ServiceLoader.load(HashSpi.class);
    }
}

