/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashMap1;
import com.github.andrewoma.dexx.collection.internal.hashmap.ListMap;
import java.util.Iterator;

class HashMapCollision1<K, V>
extends CompactHashMap<K, V> {
    private final int hash;
    private final ListMap<K, V> kvs;

    HashMapCollision1(int hash, ListMap<K, V> kvs) {
        this.hash = hash;
        this.kvs = kvs;
    }

    @Override
    public int size() {
        return this.kvs.size();
    }

    @Override
    protected V get0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        return hash == this.hash ? (V)this.kvs.get(key) : null;
    }

    @Override
    protected CompactHashMap<K, V> updated0(K key, int hash, int level, V value, Pair<K, V> kv, KeyFunction<K, V> keyFunction) {
        if (hash == this.hash) {
            return new HashMapCollision1<K, V>(hash, this.kvs.put((Object)key, (Object)value));
        }
        HashMap1<K, V> that = new HashMap1<K, V>(key, hash, value, kv);
        return HashMapCollision1.makeHashTrieMap(this.hash, this, hash, that, level, this.size() + 1);
    }

    @Override
    protected CompactHashMap<K, V> removed0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        if (hash == this.hash) {
            Map kvs1 = this.kvs.remove((Object)key);
            if (((ListMap)kvs1).isEmpty()) {
                return CompactHashMap.empty();
            }
            if (((ListMap)kvs1).tail().isEmpty()) {
                Pair kv = ((ListMap)kvs1).iterator().next();
                return new HashMap1(kv.component1(), hash, kv.component2(), kv);
            }
            return new HashMapCollision1<K, V>(hash, kvs1);
        }
        return this;
    }

    @Override
    public <U> void forEach(Function<Pair<K, V>, U> f, KeyFunction<K, V> keyFunction) {
        for (Pair<K, V> kv : this.kvs) {
            f.invoke(kv);
        }
    }

    @Override
    public Iterator<Pair<K, V>> iterator(KeyFunction<K, V> kf) {
        return this.kvs.iterator();
    }
}

