/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.memvalue;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.jena.memvalue.BunchMap;
import org.apache.jena.memvalue.HashCommon;
import org.apache.jena.memvalue.SparseArraySpliterator;
import org.apache.jena.memvalue.TripleBunch;
import org.apache.jena.shared.BrokenException;
import org.apache.jena.util.iterator.NiceIterator;

class HashedBunchMap
extends HashCommon<Object>
implements BunchMap {
    protected TripleBunch[] values;

    HashedBunchMap() {
        super(10);
        this.values = new TripleBunch[this.capacity];
    }

    @Override
    protected Object[] newKeyArray(int size) {
        return new Object[size];
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public TripleBunch get(Object key) {
        int slot = this.findSlot(key);
        return slot < 0 ? this.values[~slot] : null;
    }

    @Override
    public void put(Object key, TripleBunch value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
        } else {
            this.put$(slot, key, value);
        }
    }

    @Override
    public TripleBunch getOrSet(Object key, Function<Object, TripleBunch> setter) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return this.values[~slot];
        }
        TripleBunch value = setter.apply(key);
        this.put$(slot, key, value);
        return value;
    }

    private void put$(int slot, Object key, TripleBunch value) {
        this.keys[slot] = key;
        this.values[slot] = value;
        ++this.size;
        if (this.size == this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        TripleBunch[] oldValues = this.values;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = this.newKeyArray(this.capacity);
        this.values = new TripleBunch[this.capacity];
        for (int i = 0; i < oldCapacity; ++i) {
            Object key = oldContents[i];
            if (key == null) continue;
            int j = this.findSlot(key);
            if (j < 0) {
                throw new BrokenException("oh dear, already have a slot for " + String.valueOf(key) + ", viz " + ~j);
            }
            this.keys[j] = key;
            this.values[j] = oldValues[i];
        }
    }

    @Override
    protected void removeAssociatedValues(int here) {
        this.values[here] = null;
    }

    @Override
    protected void moveAssociatedValues(int here, int scan) {
        this.values[here] = this.values[scan];
    }

    @Override
    public Iterator<TripleBunch> iterator() {
        ArrayList<Object> movedKeys = new ArrayList<Object>();
        BasicValueIterator basic = new BasicValueIterator(this.changes, movedKeys);
        MovedValuesIterator leftovers = new MovedValuesIterator(this.changes, movedKeys);
        return basic.andThen(leftovers);
    }

    @Override
    public Spliterator<TripleBunch> spliterator() {
        int initialChanges = this.changes;
        Runnable checkForConcurrentModification = () -> {
            if (this.changes != initialChanges) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<TripleBunch>(this.values, this.size, checkForConcurrentModification);
    }

    protected final class BasicValueIterator
    extends NiceIterator<TripleBunch> {
        protected final List<Object> movedKeys;
        int pos;
        final int initialChanges;

        protected BasicValueIterator(int initialChanges, List<Object> movedKeys) {
            this.pos = HashedBunchMap.this.capacity - 1;
            this.movedKeys = movedKeys;
            this.initialChanges = initialChanges;
        }

        @Override
        public boolean hasNext() {
            while (-1 < this.pos) {
                if (null != HashedBunchMap.this.values[this.pos]) {
                    return true;
                }
                --this.pos;
            }
            return false;
        }

        @Override
        public TripleBunch next() {
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            if (-1 < this.pos && null != HashedBunchMap.this.values[this.pos]) {
                return HashedBunchMap.this.values[this.pos--];
            }
            throw new NoSuchElementException("HashCommon keys");
        }

        @Override
        public void forEachRemaining(Consumer<? super TripleBunch> action) {
            while (-1 < this.pos) {
                if (null != HashedBunchMap.this.values[this.pos]) {
                    action.accept(HashedBunchMap.this.values[this.pos]);
                }
                --this.pos;
            }
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            Object moved = HashedBunchMap.this.removeFrom(this.pos + 1);
            if (moved != null) {
                this.movedKeys.add(moved);
            }
            if (HashedBunchMap.this.size < 0) {
                throw new BrokenException("BROKEN");
            }
        }
    }

    protected final class MovedValuesIterator
    extends NiceIterator<TripleBunch> {
        private final List<Object> movedKeys;
        protected int index = 0;
        final int initialChanges;

        protected MovedValuesIterator(int initialChanges, List<Object> movedKeys) {
            this.movedKeys = movedKeys;
            this.initialChanges = initialChanges;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.movedKeys.size();
        }

        @Override
        public TripleBunch next() {
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException("changes " + HashedBunchMap.this.changes + " > initialChanges " + this.initialChanges);
            }
            if (this.index < this.movedKeys.size()) {
                return HashedBunchMap.this.get(this.movedKeys.get(this.index++));
            }
            return (TripleBunch)this.noElements("");
        }

        @Override
        public void forEachRemaining(Consumer<? super TripleBunch> action) {
            while (this.index < this.movedKeys.size()) {
                action.accept(HashedBunchMap.this.get(this.movedKeys.get(this.index++)));
            }
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (HashedBunchMap.this.changes > this.initialChanges) {
                throw new ConcurrentModificationException();
            }
            HashedBunchMap.this.primitiveRemove(this.movedKeys.get(this.index - 1));
        }
    }
}

