/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.runner;

import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiCoreInfo;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.PlatformInfo;
import org.slf4j.Logger;

public class FusekiRunnerLogging {
    public static void logCode(Logger log2) {
        FusekiCoreInfo.logCode(log2);
    }

    public static void logServerSetup(Logger log2, FusekiServer server) {
        boolean verbose = Fuseki.getVerbose(server.getServletContext());
        FusekiCoreInfo.logDataAccessPointRegistry(log2, server.getDataAccessPointRegistry(), verbose);
        if (verbose) {
            FusekiRunnerLogging.logModules(log2, server);
        }
        FmtLog.info(log2, "System", new Object[0]);
        if (verbose) {
            PlatformInfo.logSystemDetailsLong(log2);
        } else {
            PlatformInfo.logSystemDetailsShort(log2);
        }
    }

    public static void logServerStarted(Logger log2, FusekiServer server) {
        if (!server.getJettyServer().isStarted()) {
            throw new FusekiException("FusekiServer not ready");
        }
        int httpPort = server.getHttpPort();
        int httpsPort = server.getHttpsPort();
        if (httpsPort > 0) {
            PlatformInfo.logInfo(log2, "Port:", "https=%s", httpsPort);
        }
        if (httpPort > 0) {
            PlatformInfo.logInfo(log2, "Port:", "http=%s", httpPort);
        }
        log2.info("Start Fuseki");
    }

    private static void logModules(Logger log2, FusekiServer server) {
        FmtLog.info(log2, "Modules", new Object[0]);
        FusekiModules modules = server.getModules();
        if (modules == null) {
            PlatformInfo.logInfo(log2, "No modules", "", new Object[0]);
            return;
        }
        if (modules.isEmpty()) {
            PlatformInfo.logInfo(log2, "No modules", "", new Object[0]);
            return;
        }
        modules.forEach(fmod -> {
            String name = fmod.name();
            if (name == null) {
                name = fmod.getClass().getSimpleName();
            }
            PlatformInfo.logInfo(log2, "Module:", "%s", name);
        });
    }

    public static void logServerStop(Logger log2, FusekiServer server) {
        log2.info("Stopping Fuseki");
    }
}

