/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.sparql.ARQInternalErrorException;

public abstract class NodeFormatterBase
implements NodeFormatter {
    @Override
    public void format(AWriter w, Node n) {
        if (n.isBlank()) {
            this.formatBNode(w, n);
        } else if (n.isURI()) {
            this.formatURI(w, n);
        } else if (n.isLiteral()) {
            this.formatLiteral(w, n);
        } else if (n.isVariable()) {
            this.formatVar(w, n);
        } else if (Node.ANY.equals(n)) {
            w.print("ANY");
        } else if (n.isTripleTerm()) {
            this.formatTripleTerm(w, n);
        } else {
            throw new ARQInternalErrorException("Unknown node type: " + String.valueOf(n));
        }
    }

    @Override
    public void formatURI(AWriter w, Node n) {
        this.formatURI(w, n.getURI());
    }

    @Override
    public void formatBNode(AWriter w, Node n) {
        this.formatBNode(w, n.getBlankNodeLabel());
    }

    @Override
    public void formatLiteral(AWriter w, Node n) {
        RDFDatatype dt = n.getLiteralDatatype();
        String lang = n.getLiteralLanguage();
        String lex = n.getLiteralLexicalForm();
        TextDirection textDir = n.getLiteralBaseDirection();
        if (textDir != null) {
            this.formatLitLangDir(w, lex, lang, textDir.direction());
        } else if (lang != null && !lang.equals("")) {
            this.formatLitLang(w, lex, lang);
        } else if (dt == null) {
            this.formatLitString(w, lex);
        } else if (dt.equals(XSDDatatype.XSDstring)) {
            this.formatLitString(w, lex);
        } else {
            this.formatLitDT(w, lex, dt.getURI());
        }
    }

    @Override
    public void formatTripleTerm(AWriter w, Node n) {
        Triple t = n.getTriple();
        this.formatTripleTerm(w, t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public void formatTripleTerm(AWriter w, Node subject, Node predicate, Node object) {
        w.print("<<( ");
        this.format(w, subject);
        w.print(" ");
        this.format(w, predicate);
        w.print(" ");
        this.format(w, object);
        w.print(" )>>");
    }

    @Override
    public void formatVar(AWriter w, Node n) {
        this.formatVar(w, n.getName());
    }
}

