/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.cdt.ParserForCDTLiterals;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.util.Context;

public class CDTAwareParserProfile
extends ParserProfileStd {
    public CDTAwareParserProfile(FactoryRDF factory, ErrorHandler errorHandler, IRIxResolver resolver, PrefixMap prefixMap, Context context2, boolean checking, boolean strictMode) {
        super(factory, errorHandler, resolver, prefixMap, context2, checking, strictMode);
    }

    @Override
    public Node createTypedLiteral(String lex, RDFDatatype datatype, long line, long col) {
        if (datatype.equals(CompositeDatatypeList.datatype())) {
            return this.createListLiteral(lex);
        }
        if (datatype.equals(CompositeDatatypeMap.datatype())) {
            return this.createMapLiteral(lex);
        }
        return super.createTypedLiteral(lex, datatype, line, col);
    }

    protected Node createListLiteral(String lex) {
        List<CDTValue> value;
        try {
            value = ParserForCDTLiterals.parseListLiteral((ParserProfile)this, lex);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException(lex, (RDFDatatype)CompositeDatatypeList.datatype(), ex);
        }
        LiteralLabel ll = LiteralLabelFactory.createIncludingValue(lex, value, CompositeDatatypeList.datatype());
        Node n = NodeFactory.createLiteral(ll);
        return n;
    }

    protected Node createMapLiteral(String lex) {
        Map<CDTKey, CDTValue> value;
        try {
            value = ParserForCDTLiterals.parseMapLiteral((ParserProfile)this, lex);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException(lex, (RDFDatatype)CompositeDatatypeMap.datatype(), ex);
        }
        LiteralLabel ll = LiteralLabelFactory.createIncludingValue(lex, value, CompositeDatatypeMap.datatype());
        Node n = NodeFactory.createLiteral(ll);
        return n;
    }
}

