/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.internal.AbstractMap;
import org.opengis.referencing.operation.Projection;

final class AuthorityCodes
extends AbstractMap<String, String>
implements Serializable {
    private static final int MAX_CODE = 69999999;
    private static final int ALL = 0;
    private static final int ONE = 1;
    private final transient EPSGDataAccess factory;
    final Class<?> type;
    private final transient boolean isProjection;
    private final transient String[] sql = new String[2];
    private final transient Statement[] statements = new Statement[2];
    private transient ResultSet results;
    private transient IntegerList codes;

    AuthorityCodes(Connection connection, TableInfo table, Class<?> type, EPSGDataAccess factory) throws SQLException {
        this.factory = factory;
        StringBuilder buffer = new StringBuilder(100);
        int columnNameStart = buffer.append("SELECT ").length();
        int columnNameEnd = buffer.append(table.codeColumn).length();
        buffer.append(" FROM ").append(table.table);
        Class<?> tableType = table.where(type, buffer);
        int conditionStart = buffer.length();
        if (table.showColumn != null) {
            buffer.append(table.showColumn).append("<>0 AND ");
        }
        buffer.append("DEPRECATED=0 ORDER BY ").append(table.codeColumn);
        this.sql[0] = factory.translator.apply(buffer.toString());
        buffer.setLength(conditionStart);
        if (table.nameColumn != null) {
            buffer.replace(columnNameStart, columnNameEnd, table.nameColumn);
        }
        buffer.append(table.codeColumn).append(" = ?");
        this.sql[1] = factory.translator.apply(buffer.toString());
        this.type = tableType;
        this.isProjection = Projection.class.isAssignableFrom(tableType);
    }

    final CloseableReference createReference() {
        return new CloseableReference(this, this.factory, this.statements);
    }

    private boolean filter(int code) throws SQLException {
        assert (Thread.holdsLock(this.factory));
        return !this.isProjection || this.factory.isProjection(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCodeAt(int index) throws SQLException {
        int code;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int more;
            if (this.codes == null) {
                this.codes = new IntegerList(100, 69999999);
                this.statements[0] = this.factory.connection.createStatement();
                this.results = this.statements[0].executeQuery(this.sql[0]);
                this.sql[0] = null;
            }
            if ((more = index - this.codes.size()) < 0) {
                code = this.codes.getInt(index);
            } else {
                ResultSet r = this.results;
                if (r == null) {
                    code = -1;
                } else {
                    do {
                        if (!r.next()) {
                            this.results = null;
                            r.close();
                            this.statements[0].close();
                            this.statements[0] = null;
                            return -1;
                        }
                        code = r.getInt(1);
                        if (!this.filter(code)) continue;
                        this.codes.addInt(code);
                        --more;
                    } while (more >= 0);
                }
            }
        }
        return code;
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getCodeAt(0) < 0;
        }
        catch (SQLException exception) {
            throw this.factoryFailure(exception);
        }
    }

    @Override
    public int size() {
        try {
            this.getCodeAt(Integer.MAX_VALUE);
        }
        catch (SQLException exception) {
            throw this.factoryFailure(exception);
        }
        return this.codes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(Object code) {
        int n;
        if (code == null) return null;
        if (code instanceof Number) {
            n = ((Number)code).intValue();
        } else {
            try {
                n = Integer.parseInt(code.toString());
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        try {
            EPSGDataAccess e2 = this.factory;
            synchronized (e2) {
                if (!this.filter(n)) return null;
                PreparedStatement statement = (PreparedStatement)this.statements[1];
                if (statement == null) {
                    statement = this.factory.connection.prepareStatement(this.sql[1]);
                    this.statements[1] = statement;
                    this.sql[1] = null;
                }
                statement.setInt(1, n);
                try (ResultSet results = statement.executeQuery();){
                    String name;
                    do {
                        if (!results.next()) return null;
                    } while ((name = results.getString(1)) == null);
                    String string = name;
                    return string;
                }
            }
        }
        catch (SQLException exception) {
            throw this.factoryFailure(exception);
        }
    }

    @Override
    public AbstractMap.EntryIterator<String, String> entryIterator() {
        return new AbstractMap.EntryIterator<String, String>(){
            private int index = -1;
            private int code;

            @Override
            protected boolean next() {
                try {
                    this.code = AuthorityCodes.this.getCodeAt(++this.index);
                }
                catch (SQLException exception) {
                    throw AuthorityCodes.this.factoryFailure(exception);
                }
                return this.code >= 0;
            }

            @Override
            protected String getKey() {
                return String.valueOf(this.code);
            }

            @Override
            protected String getValue() {
                return "";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("AuthorityCodes[").append(this.type.getSimpleName());
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            if (this.codes != null) {
                buffer.append(", size ").append(this.results != null ? ">= " : "= ").append(this.codes.size());
            }
        }
        return buffer.append(']').toString();
    }

    private BackingStoreException factoryFailure(SQLException exception) {
        return new BackingStoreException(exception.getLocalizedMessage(), exception);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap<String, String>(this);
    }
}

