/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;

public final class ArraysExt
extends Static {
    public static final double[] EMPTY_DOUBLE = new double[0];
    public static final float[] EMPTY_FLOAT = new float[0];
    public static final long[] EMPTY_LONG = new long[0];
    public static final int[] EMPTY_INT = new int[0];
    public static final short[] EMPTY_SHORT = new short[0];
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final char[] EMPTY_CHAR = new char[0];
    public static final boolean[] EMPTY_BOOLEAN = new boolean[0];

    private ArraysExt() {
    }

    public static <E> E[] resize(E[] array, int length) {
        return array == null || array.length == length ? array : Arrays.copyOf(array, length);
    }

    public static double[] resize(double[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_DOUBLE;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static float[] resize(float[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_FLOAT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static long[] resize(long[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_LONG;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static int[] resize(int[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_INT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static short[] resize(short[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_SHORT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static byte[] resize(byte[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_BYTE;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static char[] resize(char[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_CHAR;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static boolean[] resize(boolean[] array, int length) {
        if (array != null) {
            if (length == 0) {
                return EMPTY_BOOLEAN;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    private static <T> T doRemove(T array, int first, int length) {
        if (length == 0) {
            return array;
        }
        ArgumentChecks.ensureNonNull("array", array);
        ArgumentChecks.ensurePositive("length", length);
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength -= length);
        System.arraycopy(array, 0, newArray, 0, first);
        System.arraycopy(array, first + length, newArray, first, arrayLength - first);
        return (T)newArray;
    }

    public static <E> E[] remove(E[] array, int first, int length) {
        return ArraysExt.doRemove(array, first, length);
    }

    public static double[] remove(double[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_DOUBLE : ArraysExt.doRemove(array, first, length);
    }

    public static float[] remove(float[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_FLOAT : ArraysExt.doRemove(array, first, length);
    }

    public static long[] remove(long[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_LONG : ArraysExt.doRemove(array, first, length);
    }

    public static int[] remove(int[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_INT : ArraysExt.doRemove(array, first, length);
    }

    public static short[] remove(short[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_SHORT : ArraysExt.doRemove(array, first, length);
    }

    public static byte[] remove(byte[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_BYTE : ArraysExt.doRemove(array, first, length);
    }

    public static char[] remove(char[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_CHAR : ArraysExt.doRemove(array, first, length);
    }

    public static boolean[] remove(boolean[] array, int first, int length) {
        return first == 0 && array != null && length == array.length ? EMPTY_BOOLEAN : ArraysExt.doRemove(array, first, length);
    }

    private static <T> T doInsert(T array, int first, int length) {
        if (length == 0) {
            return array;
        }
        ArgumentChecks.ensureNonNull("array", array);
        int arrayLength = Array.getLength(array);
        ArgumentChecks.ensureBetween("first", 0, arrayLength, first);
        ArgumentChecks.ensurePositive("length", length);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + length);
        System.arraycopy(array, 0, newArray, 0, first);
        System.arraycopy(array, first, newArray, first + length, arrayLength - first);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static double[] insert(double[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static float[] insert(float[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static long[] insert(long[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static int[] insert(int[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static short[] insert(short[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static byte[] insert(byte[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static char[] insert(char[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    public static boolean[] insert(boolean[] array, int first, int length) {
        return ArraysExt.doInsert(array, first, length);
    }

    private static <T> T doInsert(T src, int srcOff, T dst, int dstOff, int length) {
        if (length == 0) {
            return dst;
        }
        ArgumentChecks.ensureNonNull("src", src);
        ArgumentChecks.ensureNonNull("dst", dst);
        ArgumentChecks.ensurePositive("length", length);
        int dstLength = Array.getLength(dst);
        Object newArray = Array.newInstance(dst.getClass().getComponentType(), dstLength + length);
        System.arraycopy(dst, 0, newArray, 0, dstOff);
        System.arraycopy(src, srcOff, newArray, dstOff, length);
        System.arraycopy(dst, dstOff, newArray, dstOff + length, dstLength - dstOff);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] src, int srcOff, E[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static double[] insert(double[] src, int srcOff, double[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static float[] insert(float[] src, int srcOff, float[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static long[] insert(long[] src, int srcOff, long[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static int[] insert(int[] src, int srcOff, int[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static short[] insert(short[] src, int srcOff, short[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static byte[] insert(byte[] src, int srcOff, byte[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static char[] insert(char[] src, int srcOff, char[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static boolean[] insert(boolean[] src, int srcOff, boolean[] dst, int dstOff, int length) {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static <T> T[] append(T[] array, T element) {
        ArgumentChecks.ensureNonNull("array", array);
        T[] copy = Arrays.copyOf(array, array.length + 1);
        copy[array.length] = element;
        return copy;
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] ... arrays) {
        T[] result = null;
        if (arrays != null) {
            int length = 0;
            for (T[] array : arrays) {
                if (array == null) continue;
                length += array.length;
            }
            int offset = 0;
            for (T[] array : arrays) {
                if (array == null) continue;
                if (result == null) {
                    if (array.length == length) {
                        return array;
                    }
                    result = Arrays.copyOf(array, length);
                } else {
                    System.arraycopy(array, 0, result, offset, array.length);
                }
                offset += array.length;
            }
        }
        return result;
    }

    public static long[] concatenate(long[] a1, long[] a2) {
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        long[] copy = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, copy, a1.length, a2.length);
        return copy;
    }

    public static int[] concatenate(int[] a1, int[] a2) {
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        int[] copy = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, copy, a1.length, a2.length);
        return copy;
    }

    public static int removeDuplicated(Object[] array) {
        int length;
        if (array == null) {
            return 0;
        }
        int i = length = array.length;
        block0: while (--i >= 0) {
            Object value = array[i];
            int j = i;
            while (--j >= 0) {
                if (!Objects.equals(array[j], value)) continue;
                System.arraycopy(array, i + 1, array, i, --length - i);
                array[length] = null;
                continue block0;
            }
        }
        return length;
    }

    public static void reverse(Object[] entries) {
        if (entries != null) {
            int i = entries.length >>> 1;
            int j = i + (entries.length & 1);
            while (--i >= 0) {
                ArraysExt.swap(entries, i, j++);
            }
        }
    }

    public static void reverse(int[] values) {
        if (values != null) {
            int i = values.length >>> 1;
            int j = i + (values.length & 1);
            while (--i >= 0) {
                ArraysExt.swap(values, i, j++);
            }
        }
    }

    public static int[] range(int start, int end) {
        if (end > start) {
            int[] array = new int[Math.subtractExact(end, start)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = start + i;
            }
            return array;
        }
        return EMPTY_INT;
    }

    public static boolean isRange(int start, int[] array) {
        if (array == null) {
            return false;
        }
        if (array.length != 0) {
            if (start + (array.length - 1) < 0) {
                return false;
            }
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == start + i) continue;
                return false;
            }
        }
        return true;
    }

    public static <E> boolean isSorted(E[] array, Comparator<? super E> comparator, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            E p = array[i];
            if (p == null) continue;
            while (++i < array.length) {
                E e2 = array[i];
                if (e2 == null) continue;
                int c = comparator.compare(e2, p);
                if (strict ? c <= 0 : c < 0) {
                    return false;
                }
                p = e2;
            }
            break;
        }
        return true;
    }

    public static <E extends Comparable<? super E>> boolean isSorted(E[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            E p = array[i];
            if (p == null) continue;
            while (++i < array.length) {
                E e2 = array[i];
                if (e2 == null) continue;
                int c = e2.compareTo(p);
                if (strict ? c <= 0 : c < 0) {
                    return false;
                }
                p = e2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(double[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            double p = array[i];
            if (Double.isNaN(p)) continue;
            while (++i < array.length) {
                double e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                if (Double.isNaN(e2)) continue;
                p = e2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(float[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            float p = array[i];
            if (Float.isNaN(p)) continue;
            while (++i < array.length) {
                float e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                if (Float.isNaN(e2)) continue;
                p = e2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(long[] array, boolean strict) {
        if (array.length != 0) {
            long p = array[0];
            for (int i = 1; i < array.length; ++i) {
                long e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                p = e2;
            }
        }
        return true;
    }

    public static boolean isSorted(int[] array, boolean strict) {
        if (array.length != 0) {
            int p = array[0];
            for (int i = 1; i < array.length; ++i) {
                int e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                p = e2;
            }
        }
        return true;
    }

    public static boolean isSorted(short[] array, boolean strict) {
        if (array.length != 0) {
            short p = array[0];
            for (int i = 1; i < array.length; ++i) {
                short e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                p = e2;
            }
        }
        return true;
    }

    public static boolean isSorted(byte[] array, boolean strict) {
        if (array.length != 0) {
            byte p = array[0];
            for (int i = 1; i < array.length; ++i) {
                byte e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                p = e2;
            }
        }
        return true;
    }

    public static boolean isSorted(char[] array, boolean strict) {
        if (array.length != 0) {
            char p = array[0];
            for (int i = 1; i < array.length; ++i) {
                char e2 = array[i];
                if (strict ? e2 <= p : e2 < p) {
                    return false;
                }
                p = e2;
            }
        }
        return true;
    }

    public static void swap(Object[] data, int i0, int i1) {
        Object t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(double[] data, int i0, int i1) {
        double t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(float[] data, int i0, int i1) {
        float t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(long[] data, int i0, int i1) {
        long t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(int[] data, int i0, int i1) {
        int t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(short[] data, int i0, int i1) {
        short t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(byte[] data, int i0, int i1) {
        byte t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(char[] data, int i0, int i1) {
        char t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void replace(double[] array, double search, double replacement) {
        long bits;
        if (array != null && (bits = Double.doubleToRawLongBits(search)) != Double.doubleToRawLongBits(replacement)) {
            for (int i = 0; i < array.length; ++i) {
                if (Double.doubleToRawLongBits(array[i]) != bits) continue;
                array[i] = replacement;
            }
        }
    }

    public static void replace(float[] array, float search, float replacement) {
        int bits;
        if (array != null && (bits = Float.floatToRawIntBits(search)) != Float.floatToRawIntBits(replacement)) {
            for (int i = 0; i < array.length; ++i) {
                if (Float.floatToRawIntBits(array[i]) != bits) continue;
                array[i] = replacement;
            }
        }
    }

    public static long[] copyAsLongs(int[] data) {
        if (data == null) {
            return null;
        }
        long[] result = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }

    public static float[] copyAsFloats(double[] data) {
        if (data == null) {
            return null;
        }
        float[] result = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (float)data[i];
        }
        return result;
    }

    public static float[] copyAsFloatsIfLossless(double[] data) {
        if (data == null) {
            return null;
        }
        int i = data.length - 1;
        if (i < 0) {
            return EMPTY_FLOAT;
        }
        while (true) {
            double d;
            if (Double.doubleToRawLongBits(d = data[i]) != Double.doubleToRawLongBits((float)d)) {
                return null;
            }
            if (i == 0) break;
            i >>>= 1;
        }
        float[] result = new float[data.length];
        i = data.length;
        while (--i >= 0) {
            double d = data[i];
            float f = (float)d;
            if (Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(f)) {
                return null;
            }
            result[i] = f;
        }
        return result;
    }

    public static boolean isSinglePrecision(double ... values) {
        if (values != null) {
            for (double value : values) {
                if (Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits((float)value)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNaN(double[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!Double.isNaN(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNaN(float[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!Float.isNaN(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean allEquals(Object[] array, Object value) {
        if (value == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (value.equals(array[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(double[] array, double value) {
        if (Double.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Double.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(float[] array, float value) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Float.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        if (array != null) {
            for (String element : array) {
                if (!value.equalsIgnoreCase(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIdentity(Object[] array, Object value) {
        if (array != null) {
            for (Object element : array) {
                if (element != value) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (array != null) {
            for (Object element : array) {
                if (!Objects.equals(element, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(Object[] array1, Object[] array2) {
        if (array1 != null) {
            for (Object element : array1) {
                if (!ArraysExt.contains(array2, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] unionOfSorted(int[] array1, int[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        int[] union = new int[Math.addExact(array1.length, array2.length)];
        int nu = 0;
        int ix = 0;
        int iy = 0;
        while (true) {
            int s;
            int no;
            if (ix == array1.length) {
                no = array2.length - iy;
                System.arraycopy(array2, iy, union, nu, no);
                nu += no;
                break;
            }
            if (iy == array2.length) {
                no = array1.length - ix;
                System.arraycopy(array1, ix, union, nu, no);
                nu += no;
                break;
            }
            int sx = array1[ix];
            int sy = array2[iy];
            if (sx <= sy) {
                s = sx;
                ++ix;
                if (sx == sy) {
                    ++iy;
                }
            } else {
                s = sy;
                ++iy;
            }
            union[nu++] = s;
        }
        union = ArraysExt.resize(union, nu);
        return union;
    }
}

