/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DocumentAttributeValueType;
import com.amazonaws.services.kendra.model.Relevance;
import com.amazonaws.services.kendra.model.Search;
import com.amazonaws.services.kendra.model.transform.DocumentMetadataConfigurationMarshaller;
import java.io.Serializable;

public class DocumentMetadataConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private Relevance relevance;
    private Search search;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentMetadataConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DocumentMetadataConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public DocumentMetadataConfiguration withType(DocumentAttributeValueType type) {
        this.type = type.toString();
        return this;
    }

    public void setRelevance(Relevance relevance) {
        this.relevance = relevance;
    }

    public Relevance getRelevance() {
        return this.relevance;
    }

    public DocumentMetadataConfiguration withRelevance(Relevance relevance) {
        this.setRelevance(relevance);
        return this;
    }

    public void setSearch(Search search) {
        this.search = search;
    }

    public Search getSearch() {
        return this.search;
    }

    public DocumentMetadataConfiguration withSearch(Search search) {
        this.setSearch(search);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getRelevance() != null) {
            sb.append("Relevance: ").append(this.getRelevance()).append(",");
        }
        if (this.getSearch() != null) {
            sb.append("Search: ").append(this.getSearch());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadataConfiguration)) {
            return false;
        }
        DocumentMetadataConfiguration other = (DocumentMetadataConfiguration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getRelevance() == null ^ this.getRelevance() == null) {
            return false;
        }
        if (other.getRelevance() != null && !other.getRelevance().equals(this.getRelevance())) {
            return false;
        }
        if (other.getSearch() == null ^ this.getSearch() == null) {
            return false;
        }
        return other.getSearch() == null || other.getSearch().equals(this.getSearch());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getRelevance() == null ? 0 : this.getRelevance().hashCode());
        hashCode = 31 * hashCode + (this.getSearch() == null ? 0 : this.getSearch().hashCode());
        return hashCode;
    }

    public DocumentMetadataConfiguration clone() {
        try {
            return (DocumentMetadataConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMetadataConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

