/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.apache.wiki.htmltowiki.syntax.PlainTextBoldDecorator;
import org.jdom2.JDOMException;

public abstract class PlainTextCssDecorator {
    protected final PrintWriter out;
    protected final XHtmlElementToWikiTranslator chain;
    protected final PlainTextBoldDecorator ptbd;

    protected PlainTextCssDecorator(PlainTextBoldDecorator ptbd, PrintWriter out, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.chain = chain;
        this.ptbd = ptbd;
    }

    public void decorate(XHtmlElementToWikiTranslator.ElementDecoratorData dto) throws JDOMException {
        if (dto.cssClass != null && !dto.ignoredCssClass) {
            if (MarkupHelper.isHtmlBaseDiv(dto)) {
                this.out.print(this.markupCssDivOpen(dto.cssClass));
            } else if (MarkupHelper.isHtmlBaseSpan(dto)) {
                this.out.print(this.markupCssSpanOpen(dto.cssClass));
            }
        }
        this.ptbd.decorate(dto);
        if (dto.cssClass != null && !dto.ignoredCssClass) {
            if (MarkupHelper.isHtmlBaseDiv(dto)) {
                this.out.print(this.markupCssDivClose(dto.cssClass));
            } else if (MarkupHelper.isHtmlBaseSpan(dto)) {
                this.out.print(this.markupCssSpanClose(dto.cssClass));
            }
        }
    }

    protected abstract String markupCssDivOpen(String var1);

    protected abstract String markupCssDivClose(String var1);

    protected abstract String markupCssSpanOpen(String var1);

    protected abstract String markupCssSpanClose(String var1);
}

