/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.ProxyConfiguration;
import com.amazonaws.services.kendra.model.S3Path;
import com.amazonaws.services.kendra.model.SharePointOnlineAuthenticationType;
import com.amazonaws.services.kendra.model.SharePointVersion;
import com.amazonaws.services.kendra.model.transform.SharePointConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SharePointConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String sharePointVersion;
    private List<String> urls;
    private String secretArn;
    private Boolean crawlAttachments;
    private Boolean useChangeLog;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private DataSourceVpcConfiguration vpcConfiguration;
    private List<DataSourceToIndexFieldMapping> fieldMappings;
    private String documentTitleFieldName;
    private Boolean disableLocalGroups;
    private S3Path sslCertificateS3Path;
    private String authenticationType;
    private ProxyConfiguration proxyConfiguration;

    public void setSharePointVersion(String sharePointVersion) {
        this.sharePointVersion = sharePointVersion;
    }

    public String getSharePointVersion() {
        return this.sharePointVersion;
    }

    public SharePointConfiguration withSharePointVersion(String sharePointVersion) {
        this.setSharePointVersion(sharePointVersion);
        return this;
    }

    public SharePointConfiguration withSharePointVersion(SharePointVersion sharePointVersion) {
        this.sharePointVersion = sharePointVersion.toString();
        return this;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(Collection<String> urls) {
        if (urls == null) {
            this.urls = null;
            return;
        }
        this.urls = new ArrayList<String>(urls);
    }

    public SharePointConfiguration withUrls(String ... urls) {
        if (this.urls == null) {
            this.setUrls(new ArrayList<String>(urls.length));
        }
        for (String ele : urls) {
            this.urls.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withUrls(Collection<String> urls) {
        this.setUrls(urls);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public SharePointConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setCrawlAttachments(Boolean crawlAttachments) {
        this.crawlAttachments = crawlAttachments;
    }

    public Boolean getCrawlAttachments() {
        return this.crawlAttachments;
    }

    public SharePointConfiguration withCrawlAttachments(Boolean crawlAttachments) {
        this.setCrawlAttachments(crawlAttachments);
        return this;
    }

    public Boolean isCrawlAttachments() {
        return this.crawlAttachments;
    }

    public void setUseChangeLog(Boolean useChangeLog) {
        this.useChangeLog = useChangeLog;
    }

    public Boolean getUseChangeLog() {
        return this.useChangeLog;
    }

    public SharePointConfiguration withUseChangeLog(Boolean useChangeLog) {
        this.setUseChangeLog(useChangeLog);
        return this;
    }

    public Boolean isUseChangeLog() {
        return this.useChangeLog;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public SharePointConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public SharePointConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public SharePointConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public SharePointConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public void setDocumentTitleFieldName(String documentTitleFieldName) {
        this.documentTitleFieldName = documentTitleFieldName;
    }

    public String getDocumentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public SharePointConfiguration withDocumentTitleFieldName(String documentTitleFieldName) {
        this.setDocumentTitleFieldName(documentTitleFieldName);
        return this;
    }

    public void setDisableLocalGroups(Boolean disableLocalGroups) {
        this.disableLocalGroups = disableLocalGroups;
    }

    public Boolean getDisableLocalGroups() {
        return this.disableLocalGroups;
    }

    public SharePointConfiguration withDisableLocalGroups(Boolean disableLocalGroups) {
        this.setDisableLocalGroups(disableLocalGroups);
        return this;
    }

    public Boolean isDisableLocalGroups() {
        return this.disableLocalGroups;
    }

    public void setSslCertificateS3Path(S3Path sslCertificateS3Path) {
        this.sslCertificateS3Path = sslCertificateS3Path;
    }

    public S3Path getSslCertificateS3Path() {
        return this.sslCertificateS3Path;
    }

    public SharePointConfiguration withSslCertificateS3Path(S3Path sslCertificateS3Path) {
        this.setSslCertificateS3Path(sslCertificateS3Path);
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public SharePointConfiguration withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public SharePointConfiguration withAuthenticationType(SharePointOnlineAuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public SharePointConfiguration withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.setProxyConfiguration(proxyConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSharePointVersion() != null) {
            sb.append("SharePointVersion: ").append(this.getSharePointVersion()).append(",");
        }
        if (this.getUrls() != null) {
            sb.append("Urls: ").append(this.getUrls()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getCrawlAttachments() != null) {
            sb.append("CrawlAttachments: ").append(this.getCrawlAttachments()).append(",");
        }
        if (this.getUseChangeLog() != null) {
            sb.append("UseChangeLog: ").append(this.getUseChangeLog()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings()).append(",");
        }
        if (this.getDocumentTitleFieldName() != null) {
            sb.append("DocumentTitleFieldName: ").append(this.getDocumentTitleFieldName()).append(",");
        }
        if (this.getDisableLocalGroups() != null) {
            sb.append("DisableLocalGroups: ").append(this.getDisableLocalGroups()).append(",");
        }
        if (this.getSslCertificateS3Path() != null) {
            sb.append("SslCertificateS3Path: ").append(this.getSslCertificateS3Path()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getProxyConfiguration() != null) {
            sb.append("ProxyConfiguration: ").append(this.getProxyConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointConfiguration)) {
            return false;
        }
        SharePointConfiguration other = (SharePointConfiguration)obj;
        if (other.getSharePointVersion() == null ^ this.getSharePointVersion() == null) {
            return false;
        }
        if (other.getSharePointVersion() != null && !other.getSharePointVersion().equals(this.getSharePointVersion())) {
            return false;
        }
        if (other.getUrls() == null ^ this.getUrls() == null) {
            return false;
        }
        if (other.getUrls() != null && !other.getUrls().equals(this.getUrls())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getCrawlAttachments() == null ^ this.getCrawlAttachments() == null) {
            return false;
        }
        if (other.getCrawlAttachments() != null && !other.getCrawlAttachments().equals(this.getCrawlAttachments())) {
            return false;
        }
        if (other.getUseChangeLog() == null ^ this.getUseChangeLog() == null) {
            return false;
        }
        if (other.getUseChangeLog() != null && !other.getUseChangeLog().equals(this.getUseChangeLog())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        if (other.getFieldMappings() != null && !other.getFieldMappings().equals(this.getFieldMappings())) {
            return false;
        }
        if (other.getDocumentTitleFieldName() == null ^ this.getDocumentTitleFieldName() == null) {
            return false;
        }
        if (other.getDocumentTitleFieldName() != null && !other.getDocumentTitleFieldName().equals(this.getDocumentTitleFieldName())) {
            return false;
        }
        if (other.getDisableLocalGroups() == null ^ this.getDisableLocalGroups() == null) {
            return false;
        }
        if (other.getDisableLocalGroups() != null && !other.getDisableLocalGroups().equals(this.getDisableLocalGroups())) {
            return false;
        }
        if (other.getSslCertificateS3Path() == null ^ this.getSslCertificateS3Path() == null) {
            return false;
        }
        if (other.getSslCertificateS3Path() != null && !other.getSslCertificateS3Path().equals(this.getSslCertificateS3Path())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getProxyConfiguration() == null ^ this.getProxyConfiguration() == null) {
            return false;
        }
        return other.getProxyConfiguration() == null || other.getProxyConfiguration().equals(this.getProxyConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSharePointVersion() == null ? 0 : this.getSharePointVersion().hashCode());
        hashCode = 31 * hashCode + (this.getUrls() == null ? 0 : this.getUrls().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlAttachments() == null ? 0 : this.getCrawlAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getUseChangeLog() == null ? 0 : this.getUseChangeLog().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentTitleFieldName() == null ? 0 : this.getDocumentTitleFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getDisableLocalGroups() == null ? 0 : this.getDisableLocalGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSslCertificateS3Path() == null ? 0 : this.getSslCertificateS3Path().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getProxyConfiguration() == null ? 0 : this.getProxyConfiguration().hashCode());
        return hashCode;
    }

    public SharePointConfiguration clone() {
        try {
            return (SharePointConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharePointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

