/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.AuthenticationConfiguration;
import com.amazonaws.services.kendra.model.ProxyConfiguration;
import com.amazonaws.services.kendra.model.Urls;
import com.amazonaws.services.kendra.model.transform.WebCrawlerConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WebCrawlerConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Urls urls;
    private Integer crawlDepth;
    private Integer maxLinksPerPage;
    private Float maxContentSizePerPageInMegaBytes;
    private Integer maxUrlsPerMinuteCrawlRate;
    private List<String> urlInclusionPatterns;
    private List<String> urlExclusionPatterns;
    private ProxyConfiguration proxyConfiguration;
    private AuthenticationConfiguration authenticationConfiguration;

    public void setUrls(Urls urls) {
        this.urls = urls;
    }

    public Urls getUrls() {
        return this.urls;
    }

    public WebCrawlerConfiguration withUrls(Urls urls) {
        this.setUrls(urls);
        return this;
    }

    public void setCrawlDepth(Integer crawlDepth) {
        this.crawlDepth = crawlDepth;
    }

    public Integer getCrawlDepth() {
        return this.crawlDepth;
    }

    public WebCrawlerConfiguration withCrawlDepth(Integer crawlDepth) {
        this.setCrawlDepth(crawlDepth);
        return this;
    }

    public void setMaxLinksPerPage(Integer maxLinksPerPage) {
        this.maxLinksPerPage = maxLinksPerPage;
    }

    public Integer getMaxLinksPerPage() {
        return this.maxLinksPerPage;
    }

    public WebCrawlerConfiguration withMaxLinksPerPage(Integer maxLinksPerPage) {
        this.setMaxLinksPerPage(maxLinksPerPage);
        return this;
    }

    public void setMaxContentSizePerPageInMegaBytes(Float maxContentSizePerPageInMegaBytes) {
        this.maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes;
    }

    public Float getMaxContentSizePerPageInMegaBytes() {
        return this.maxContentSizePerPageInMegaBytes;
    }

    public WebCrawlerConfiguration withMaxContentSizePerPageInMegaBytes(Float maxContentSizePerPageInMegaBytes) {
        this.setMaxContentSizePerPageInMegaBytes(maxContentSizePerPageInMegaBytes);
        return this;
    }

    public void setMaxUrlsPerMinuteCrawlRate(Integer maxUrlsPerMinuteCrawlRate) {
        this.maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate;
    }

    public Integer getMaxUrlsPerMinuteCrawlRate() {
        return this.maxUrlsPerMinuteCrawlRate;
    }

    public WebCrawlerConfiguration withMaxUrlsPerMinuteCrawlRate(Integer maxUrlsPerMinuteCrawlRate) {
        this.setMaxUrlsPerMinuteCrawlRate(maxUrlsPerMinuteCrawlRate);
        return this;
    }

    public List<String> getUrlInclusionPatterns() {
        return this.urlInclusionPatterns;
    }

    public void setUrlInclusionPatterns(Collection<String> urlInclusionPatterns) {
        if (urlInclusionPatterns == null) {
            this.urlInclusionPatterns = null;
            return;
        }
        this.urlInclusionPatterns = new ArrayList<String>(urlInclusionPatterns);
    }

    public WebCrawlerConfiguration withUrlInclusionPatterns(String ... urlInclusionPatterns) {
        if (this.urlInclusionPatterns == null) {
            this.setUrlInclusionPatterns(new ArrayList<String>(urlInclusionPatterns.length));
        }
        for (String ele : urlInclusionPatterns) {
            this.urlInclusionPatterns.add(ele);
        }
        return this;
    }

    public WebCrawlerConfiguration withUrlInclusionPatterns(Collection<String> urlInclusionPatterns) {
        this.setUrlInclusionPatterns(urlInclusionPatterns);
        return this;
    }

    public List<String> getUrlExclusionPatterns() {
        return this.urlExclusionPatterns;
    }

    public void setUrlExclusionPatterns(Collection<String> urlExclusionPatterns) {
        if (urlExclusionPatterns == null) {
            this.urlExclusionPatterns = null;
            return;
        }
        this.urlExclusionPatterns = new ArrayList<String>(urlExclusionPatterns);
    }

    public WebCrawlerConfiguration withUrlExclusionPatterns(String ... urlExclusionPatterns) {
        if (this.urlExclusionPatterns == null) {
            this.setUrlExclusionPatterns(new ArrayList<String>(urlExclusionPatterns.length));
        }
        for (String ele : urlExclusionPatterns) {
            this.urlExclusionPatterns.add(ele);
        }
        return this;
    }

    public WebCrawlerConfiguration withUrlExclusionPatterns(Collection<String> urlExclusionPatterns) {
        this.setUrlExclusionPatterns(urlExclusionPatterns);
        return this;
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public WebCrawlerConfiguration withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.setProxyConfiguration(proxyConfiguration);
        return this;
    }

    public void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public WebCrawlerConfiguration withAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.setAuthenticationConfiguration(authenticationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUrls() != null) {
            sb.append("Urls: ").append(this.getUrls()).append(",");
        }
        if (this.getCrawlDepth() != null) {
            sb.append("CrawlDepth: ").append(this.getCrawlDepth()).append(",");
        }
        if (this.getMaxLinksPerPage() != null) {
            sb.append("MaxLinksPerPage: ").append(this.getMaxLinksPerPage()).append(",");
        }
        if (this.getMaxContentSizePerPageInMegaBytes() != null) {
            sb.append("MaxContentSizePerPageInMegaBytes: ").append(this.getMaxContentSizePerPageInMegaBytes()).append(",");
        }
        if (this.getMaxUrlsPerMinuteCrawlRate() != null) {
            sb.append("MaxUrlsPerMinuteCrawlRate: ").append(this.getMaxUrlsPerMinuteCrawlRate()).append(",");
        }
        if (this.getUrlInclusionPatterns() != null) {
            sb.append("UrlInclusionPatterns: ").append(this.getUrlInclusionPatterns()).append(",");
        }
        if (this.getUrlExclusionPatterns() != null) {
            sb.append("UrlExclusionPatterns: ").append(this.getUrlExclusionPatterns()).append(",");
        }
        if (this.getProxyConfiguration() != null) {
            sb.append("ProxyConfiguration: ").append(this.getProxyConfiguration()).append(",");
        }
        if (this.getAuthenticationConfiguration() != null) {
            sb.append("AuthenticationConfiguration: ").append(this.getAuthenticationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerConfiguration)) {
            return false;
        }
        WebCrawlerConfiguration other = (WebCrawlerConfiguration)obj;
        if (other.getUrls() == null ^ this.getUrls() == null) {
            return false;
        }
        if (other.getUrls() != null && !other.getUrls().equals(this.getUrls())) {
            return false;
        }
        if (other.getCrawlDepth() == null ^ this.getCrawlDepth() == null) {
            return false;
        }
        if (other.getCrawlDepth() != null && !other.getCrawlDepth().equals(this.getCrawlDepth())) {
            return false;
        }
        if (other.getMaxLinksPerPage() == null ^ this.getMaxLinksPerPage() == null) {
            return false;
        }
        if (other.getMaxLinksPerPage() != null && !other.getMaxLinksPerPage().equals(this.getMaxLinksPerPage())) {
            return false;
        }
        if (other.getMaxContentSizePerPageInMegaBytes() == null ^ this.getMaxContentSizePerPageInMegaBytes() == null) {
            return false;
        }
        if (other.getMaxContentSizePerPageInMegaBytes() != null && !other.getMaxContentSizePerPageInMegaBytes().equals(this.getMaxContentSizePerPageInMegaBytes())) {
            return false;
        }
        if (other.getMaxUrlsPerMinuteCrawlRate() == null ^ this.getMaxUrlsPerMinuteCrawlRate() == null) {
            return false;
        }
        if (other.getMaxUrlsPerMinuteCrawlRate() != null && !other.getMaxUrlsPerMinuteCrawlRate().equals(this.getMaxUrlsPerMinuteCrawlRate())) {
            return false;
        }
        if (other.getUrlInclusionPatterns() == null ^ this.getUrlInclusionPatterns() == null) {
            return false;
        }
        if (other.getUrlInclusionPatterns() != null && !other.getUrlInclusionPatterns().equals(this.getUrlInclusionPatterns())) {
            return false;
        }
        if (other.getUrlExclusionPatterns() == null ^ this.getUrlExclusionPatterns() == null) {
            return false;
        }
        if (other.getUrlExclusionPatterns() != null && !other.getUrlExclusionPatterns().equals(this.getUrlExclusionPatterns())) {
            return false;
        }
        if (other.getProxyConfiguration() == null ^ this.getProxyConfiguration() == null) {
            return false;
        }
        if (other.getProxyConfiguration() != null && !other.getProxyConfiguration().equals(this.getProxyConfiguration())) {
            return false;
        }
        if (other.getAuthenticationConfiguration() == null ^ this.getAuthenticationConfiguration() == null) {
            return false;
        }
        return other.getAuthenticationConfiguration() == null || other.getAuthenticationConfiguration().equals(this.getAuthenticationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUrls() == null ? 0 : this.getUrls().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlDepth() == null ? 0 : this.getCrawlDepth().hashCode());
        hashCode = 31 * hashCode + (this.getMaxLinksPerPage() == null ? 0 : this.getMaxLinksPerPage().hashCode());
        hashCode = 31 * hashCode + (this.getMaxContentSizePerPageInMegaBytes() == null ? 0 : this.getMaxContentSizePerPageInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxUrlsPerMinuteCrawlRate() == null ? 0 : this.getMaxUrlsPerMinuteCrawlRate().hashCode());
        hashCode = 31 * hashCode + (this.getUrlInclusionPatterns() == null ? 0 : this.getUrlInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getUrlExclusionPatterns() == null ? 0 : this.getUrlExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getProxyConfiguration() == null ? 0 : this.getProxyConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationConfiguration() == null ? 0 : this.getAuthenticationConfiguration().hashCode());
        return hashCode;
    }

    public WebCrawlerConfiguration clone() {
        try {
            return (WebCrawlerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebCrawlerConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

